/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.archives.ArchiveReplacement;
import java.util.ArrayList;
import java.util.Collection;

public class ArchiveInfo
extends ArchiveReplacement
implements Comparable<ArchiveInfo> {
    private final ArchiveInfo[] mDependsOn;
    private final ArrayList<ArchiveInfo> mDependencyFor = new ArrayList();
    private boolean mAccepted;
    private boolean mRejected;

    public ArchiveInfo(@Nullable Archive newArchive, @Nullable Archive replaced, @Nullable ArchiveInfo[] dependsOn) {
        super(newArchive, replaced);
        this.mDependsOn = dependsOn;
    }

    @Nullable
    public ArchiveInfo[] getDependsOn() {
        return this.mDependsOn;
    }

    public boolean isDependencyFor() {
        return this.mDependencyFor.size() > 0;
    }

    @NonNull
    public ArchiveInfo addDependencyFor(ArchiveInfo dependencyFor) {
        if (!this.mDependencyFor.contains(dependencyFor)) {
            this.mDependencyFor.add(dependencyFor);
        }
        return this;
    }

    @NonNull
    public Collection<ArchiveInfo> getDependenciesFor() {
        return this.mDependencyFor;
    }

    public void setAccepted(boolean accepted) {
        this.mAccepted = accepted;
    }

    public boolean isAccepted() {
        return this.mAccepted;
    }

    public void setRejected(boolean rejected) {
        this.mRejected = rejected;
    }

    public boolean isRejected() {
        return this.mRejected;
    }

    @Override
    public int compareTo(ArchiveInfo rhs) {
        if (this.getNewArchive() != null && rhs != null) {
            return this.getNewArchive().compareTo(rhs.getNewArchive());
        }
        return 0;
    }
}

