/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.packages.IMinToolsDependency;
import com.android.sdklib.internal.repository.packages.MinToolsMixin;
import com.android.sdklib.internal.repository.packages.NoPreviewRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.utils.NullLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class ExtraPackage
extends NoPreviewRevisionPackage
implements IMinApiLevelDependency,
IMinToolsDependency {
    private final MinToolsMixin mMinToolsMixin;
    private final String mDisplayName;
    private final String mVendorId;
    private final String mVendorDisplay;
    private final String mPath;
    private final String mOldPaths;
    private final int mMinApiLevel;
    private final String[] mProjectFiles;
    private final IPkgDescExtra mPkgDesc;

    public ExtraPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mMinToolsMixin = new MinToolsMixin(packageNode);
        this.mPath = PackageParserUtils.getXmlString(packageNode, "path");
        String name = PackageParserUtils.getXmlString(packageNode, "name-display");
        String vname = PackageParserUtils.getXmlString(packageNode, "vendor-display");
        String vid = PackageParserUtils.getXmlString(packageNode, "vendor-id");
        if (vid.length() == 0) {
            String vendor = PackageParserUtils.getXmlString(packageNode, "vendor");
            vid = this.sanitizeLegacyVendor(vendor);
            if (vname.length() == 0) {
                vname = vendor;
            }
        }
        if (vname.length() == 0) {
            vname = vid;
        }
        this.mVendorDisplay = vname.trim();
        this.mVendorId = vid.trim();
        if (name.length() == 0) {
            name = this.getPrettyName();
        }
        this.mDisplayName = name.trim();
        this.mMinApiLevel = PackageParserUtils.getXmlInt(packageNode, "min-api-level", 0);
        this.mProjectFiles = this.parseProjectFiles(PackageParserUtils.findChildElement(packageNode, "project-files"));
        this.mOldPaths = PackageParserUtils.getXmlString(packageNode, "old-paths");
        this.mPkgDesc = PkgDesc.newExtra(this.mVendorId, this.mPath, this.getOldPaths(), this.getRevision());
    }

    private String[] parseProjectFiles(Node projectFilesNode) {
        ArrayList<String> paths = new ArrayList<String>();
        if (projectFilesNode != null) {
            String nsUri = projectFilesNode.getNamespaceURI();
            for (Node child = projectFilesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                String path;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"path".equals(child.getLocalName()) || (path = child.getTextContent()) == null || (path = path.trim()).length() <= 0) continue;
                paths.add(path);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static Package create(SdkSource source, Properties props, String vendor, String path, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        ExtraPackage ep = new ExtraPackage(source, props, vendor, path, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        return ep;
    }

    protected ExtraPackage(SdkSource source, Properties props, String vendorId, String path, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        String vid;
        this.mMinToolsMixin = new MinToolsMixin(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        this.mPath = path != null ? path : ExtraPackage.getProperty(props, "Extra.Path", path);
        String name = ExtraPackage.getProperty(props, "Extra.NameDisplay", "");
        String vname = ExtraPackage.getProperty(props, "Extra.VendorDisplay", "");
        String string = vid = vendorId != null ? vendorId : ExtraPackage.getProperty(props, "Extra.VendorId", "");
        if (vid == null || vid.length() == 0) {
            String vendor = ExtraPackage.getProperty(props, "Extra.Vendor", "");
            vid = this.sanitizeLegacyVendor(vendor);
            if (vname == null || vname.length() == 0) {
                vname = vendor;
            }
        }
        if (vname == null || vname.length() == 0) {
            vname = vid;
        }
        this.mVendorDisplay = vname.trim();
        this.mVendorId = vid.trim();
        if (name == null || name.length() == 0) {
            name = this.getPrettyName();
        }
        this.mDisplayName = name.trim();
        this.mOldPaths = ExtraPackage.getProperty(props, "Extra.OldPaths", null);
        this.mMinApiLevel = ExtraPackage.getPropertyInt(props, "Extra.MinApiLevel", 0);
        String projectFiles = ExtraPackage.getProperty(props, "Extra.ProjectFiles", null);
        ArrayList<String> filePaths = new ArrayList<String>();
        if (projectFiles != null && projectFiles.length() > 0) {
            for (String filePath : projectFiles.split(Pattern.quote(File.pathSeparator))) {
                if ((filePath = filePath.trim()).length() <= 0) continue;
                filePaths.add(filePath);
            }
        }
        this.mProjectFiles = filePaths.toArray(new String[filePaths.size()]);
        this.mPkgDesc = PkgDesc.newExtra(this.mVendorId, this.mPath, this.getOldPaths(), this.getRevision());
    }

    @Override
    @NonNull
    public IPkgDescExtra getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mMinToolsMixin.saveProperties(props);
        props.setProperty("Extra.Path", this.mPath);
        props.setProperty("Extra.NameDisplay", this.mDisplayName);
        props.setProperty("Extra.VendorDisplay", this.mVendorDisplay);
        props.setProperty("Extra.VendorId", this.mVendorId);
        if (this.getMinApiLevel() != 0) {
            props.setProperty("Extra.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
        if (this.mProjectFiles.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mProjectFiles.length; ++i) {
                if (i > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(this.mProjectFiles[i]);
            }
            props.setProperty("Extra.ProjectFiles", sb.toString());
        }
        if (this.mOldPaths != null && this.mOldPaths.length() > 0) {
            props.setProperty("Extra.OldPaths", this.mOldPaths);
        }
    }

    @Override
    public FullRevision getMinToolsRevision() {
        return this.mMinToolsMixin.getMinToolsRevision();
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    public String[] getProjectFiles() {
        return this.mProjectFiles;
    }

    public String[] getOldPaths() {
        return PkgDescExtra.convertOldPaths(this.mOldPaths);
    }

    public String getPath() {
        String path = this.mPath.replaceAll("[^a-zA-Z0-9-]+", "_");
        if (path.length() == 0 || path.equals("_")) {
            int h = path.hashCode();
            path = String.format("extra%08x", h);
        }
        return path;
    }

    public String getVendorId() {
        return this.mVendorId;
    }

    public String getVendorDisplay() {
        return this.mVendorDisplay;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    private String sanitizeLegacyVendor(String vendorDisplay) {
        if (vendorDisplay != null && vendorDisplay.length() > 0) {
            String vendor = vendorDisplay.trim();
            if ((vendor = vendor.replaceAll("[^a-zA-Z0-9-]+", "_")).equals("_")) {
                int h = vendor.hashCode();
                vendor = String.format("vendor%08x", h);
            }
            return vendor;
        }
        return "";
    }

    private String getPrettyName() {
        String name = this.mPath;
        if (this.mVendorDisplay != null && this.mVendorDisplay.length() > 0 && name.startsWith(this.mVendorDisplay + "-")) {
            name = name.substring(this.mVendorDisplay.length() + 1);
        }
        if (name != null) {
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        if (name == null || name.length() == 0) {
            name = "Unknown Extra";
        }
        if (this.mVendorDisplay != null && this.mVendorDisplay.length() > 0) {
            name = this.mVendorDisplay + " " + name;
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        boolean changed = false;
        char[] chars = name.toCharArray();
        int n = chars.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLowerCase(chars[i]) || i != 0 && chars[i - 1] != ' ') continue;
            chars[i] = Character.toUpperCase(chars[i]);
            changed = true;
        }
        if (changed) {
            name = new String(chars);
        }
        name = name.replaceAll(" Usb ", " USB ");
        name = name.replaceAll(" Api ", " API ");
        return name;
    }

    @Override
    public String installId() {
        return String.format("extra-%1$s-%2$s", this.getVendorId(), this.getPath());
    }

    @Override
    public String getListDescription() {
        String s = String.format("%1$s%2$s", this.getDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getShortDescription() {
        String s = String.format("%1$s, revision %2$s%3$s", this.getDisplayName(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getLongDescription() {
        File localPath;
        String s = String.format("%1$s, revision %2$s%3$s\nBy %4$s", this.getDisplayName(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "", this.getVendorDisplay());
        String d = this.getDescription();
        if (d != null && d.length() > 0) {
            s = s + '\n' + d;
        }
        if (!this.getMinToolsRevision().equals(MIN_TOOLS_REV_NOT_SPECIFIED)) {
            s = s + String.format("\nRequires tools revision %1$s", this.getMinToolsRevision().toShortString());
        }
        if (this.getMinApiLevel() != 0) {
            s = s + String.format("\nRequires SDK Platform Android API %1$s", this.getMinApiLevel());
        }
        s = (localPath = this.getLocalArchivePath()) != null ? s + String.format("\nLocation: %1$s", localPath.getAbsolutePath()) : s + String.format("\nInstall path: %1$s", this.getInstallSubFolder(null).getPath());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        Package[] pkgs;
        LocalSdkParser localParser = new LocalSdkParser();
        for (Package pkg : pkgs = localParser.parseSdk(osSdkRoot, sdkManager, LocalSdkParser.PARSE_EXTRAS, new NullTaskMonitor(NullLogger.getLogger()))) {
            File localPath;
            if (!this.sameItemAs(pkg) || !(pkg instanceof ExtraPackage) || (localPath = ((ExtraPackage)pkg).getLocalArchivePath()) == null) continue;
            return localPath;
        }
        return this.getInstallSubFolder(osSdkRoot);
    }

    private File getInstallSubFolder(@Nullable String osSdkRoot) {
        String name;
        File path = new File(osSdkRoot, "extras");
        String vendor = this.getVendorId();
        if (vendor != null && vendor.length() > 0) {
            path = new File(path, vendor);
        }
        if ((name = this.getPath()) != null && name.length() > 0) {
            path = new File(path, name);
        }
        return path;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof ExtraPackage) {
            ExtraPackage ep = (ExtraPackage)pkg;
            return PkgDescExtra.compatibleVendorAndPath(this.mPkgDesc, ep.mPkgDesc);
        }
        return false;
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        s = s.substring(0, pos) + "|ve:" + this.getVendorId() + "|pa:" + this.getPath() + s.substring(pos);
        return s;
    }

    private File getLocalArchivePath() {
        File path;
        Archive[] archives = this.getArchives();
        if (archives.length == 1 && archives[0].isLocal() && (path = new File(archives[0].getLocalOsPath())).isDirectory()) {
            return path;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.mMinToolsMixin.hashCode(super.hashCode());
        result = 31 * result + this.mMinApiLevel;
        result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
        result = 31 * result + Arrays.hashCode(this.mProjectFiles);
        result = 31 * result + (this.mVendorDisplay == null ? 0 : this.mVendorDisplay.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtraPackage)) {
            return false;
        }
        ExtraPackage other = (ExtraPackage)obj;
        if (this.mMinApiLevel != other.mMinApiLevel) {
            return false;
        }
        if (this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath)) {
            return false;
        }
        if (!Arrays.equals(this.mProjectFiles, other.mProjectFiles)) {
            return false;
        }
        if (this.mVendorDisplay == null ? other.mVendorDisplay != null : !this.mVendorDisplay.equals(other.mVendorDisplay)) {
            return false;
        }
        return this.mMinToolsMixin.equals(obj);
    }
}

