/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.UiMode;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import java.awt.Point;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceWriter {
    public static final String LOCAL_NS = "d";
    public static final String PREFIX = "d:";

    private DeviceWriter() {
    }

    public static void writeToXml(OutputStream out, Collection<Device> devices) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("d:devices");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns:d", "http://schemas.android.com/sdk/devices/1");
        doc.appendChild(root);
        for (Device device : devices) {
            Element deviceNode = doc.createElement("d:device");
            root.appendChild(deviceNode);
            Element name = doc.createElement("d:name");
            String displayName = device.getDisplayName();
            name.appendChild(doc.createTextNode(displayName));
            deviceNode.appendChild(name);
            String deviceId = device.getId();
            if (!deviceId.equals(displayName)) {
                Element id = doc.createElement("d:id");
                id.appendChild(doc.createTextNode(deviceId));
                deviceNode.appendChild(id);
            }
            Element manufacturer = doc.createElement("d:manufacturer");
            manufacturer.appendChild(doc.createTextNode(device.getManufacturer()));
            deviceNode.appendChild(manufacturer);
            deviceNode.appendChild(DeviceWriter.generateMetaNode(device.getMeta(), doc));
            deviceNode.appendChild(DeviceWriter.generateHardwareNode(device.getDefaultHardware(), doc));
            for (Software sw : device.getAllSoftware()) {
                deviceNode.appendChild(DeviceWriter.generateSoftwareNode(sw, doc));
            }
            for (State s : device.getAllStates()) {
                deviceNode.appendChild(DeviceWriter.generateStateNode(s, doc, device.getDefaultHardware()));
            }
        }
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        tf.transform(source, result);
    }

    private static Node generateMetaNode(Meta meta, Document doc) {
        Element m = doc.createElement("d:meta");
        if (meta.hasIconSixtyFour() || meta.hasIconSixteen()) {
            Element icons = doc.createElement("d:icons");
            m.appendChild(icons);
            if (meta.hasIconSixtyFour()) {
                DeviceWriter.addElement(doc, icons, "sixty-four", meta.getIconSixtyFour().getPath());
            }
            if (meta.hasIconSixteen()) {
                DeviceWriter.addElement(doc, icons, "sixteen", meta.getIconSixteen().getPath());
            }
        }
        if (meta.hasFrame()) {
            Element frame = doc.createElement("d:frame");
            DeviceWriter.addElement(doc, frame, "path", meta.getFrame().getPath());
            Point offset = meta.getFrameOffsetPortrait();
            DeviceWriter.addElement(doc, frame, "portrait-x-offset", Integer.toString(offset.x));
            DeviceWriter.addElement(doc, frame, "portrait-y-offset", Integer.toString(offset.y));
            offset = meta.getFrameOffsetLandscape();
            DeviceWriter.addElement(doc, frame, "landscape-x-offset", Integer.toString(offset.x));
            DeviceWriter.addElement(doc, frame, "landscape-y-offset", Integer.toString(offset.y));
        }
        return m;
    }

    private static Element generateHardwareNode(Hardware hw, Document doc) {
        Screen s = hw.getScreen();
        Element hardware = doc.createElement("d:hardware");
        Element screen = doc.createElement("d:screen");
        hardware.appendChild(screen);
        DeviceWriter.addElement(doc, screen, "screen-size", s.getSize().getResourceValue());
        DeviceWriter.addElement(doc, screen, "diagonal-length", String.format(Locale.US, "%.2f", s.getDiagonalLength()));
        DeviceWriter.addElement(doc, screen, "pixel-density", s.getPixelDensity().getResourceValue());
        DeviceWriter.addElement(doc, screen, "screen-ratio", s.getRatio().getResourceValue());
        Element dimensions = doc.createElement("d:dimensions");
        screen.appendChild(dimensions);
        DeviceWriter.addElement(doc, dimensions, "x-dimension", Integer.toString(s.getXDimension()));
        DeviceWriter.addElement(doc, dimensions, "y-dimension", Integer.toString(s.getYDimension()));
        DeviceWriter.addElement(doc, screen, "xdpi", String.format(Locale.US, "%.2f", s.getXdpi()));
        DeviceWriter.addElement(doc, screen, "ydpi", String.format(Locale.US, "%.2f", s.getYdpi()));
        Element touch = doc.createElement("d:touch");
        screen.appendChild(touch);
        DeviceWriter.addElement(doc, touch, "multitouch", s.getMultitouch().toString());
        DeviceWriter.addElement(doc, touch, "mechanism", s.getMechanism().getResourceValue());
        DeviceWriter.addElement(doc, touch, "screen-type", s.getScreenType().toString());
        DeviceWriter.addElement(doc, hardware, "networking", hw.getNetworking());
        DeviceWriter.addElement(doc, hardware, "sensors", hw.getSensors());
        DeviceWriter.addElement(doc, hardware, "mic", Boolean.toString(hw.hasMic()));
        for (Camera c : hw.getCameras()) {
            Element camera = doc.createElement("d:camera");
            hardware.appendChild(camera);
            DeviceWriter.addElement(doc, camera, "location", c.getLocation().toString());
            DeviceWriter.addElement(doc, camera, "autofocus", Boolean.toString(c.hasAutofocus()));
            DeviceWriter.addElement(doc, camera, "flash", Boolean.toString(c.hasFlash()));
        }
        DeviceWriter.addElement(doc, hardware, "keyboard", hw.getKeyboard().getResourceValue());
        DeviceWriter.addElement(doc, hardware, "nav", hw.getNav().getResourceValue());
        Storage.Unit unit = hw.getRam().getAppropriateUnits();
        Element ram = DeviceWriter.addElement(doc, hardware, "ram", Long.toString(hw.getRam().getSizeAsUnit(unit)));
        ram.setAttribute("unit", unit.toString());
        DeviceWriter.addElement(doc, hardware, "buttons", hw.getButtonType().toString());
        DeviceWriter.addStorageElement(doc, hardware, "internal-storage", hw.getInternalStorage());
        DeviceWriter.addStorageElement(doc, hardware, "removable-storage", hw.getRemovableStorage());
        DeviceWriter.addElement(doc, hardware, "cpu", hw.getCpu());
        DeviceWriter.addElement(doc, hardware, "gpu", hw.getGpu());
        DeviceWriter.addElement(doc, hardware, "abi", hw.getSupportedAbis());
        StringBuilder sb = new StringBuilder();
        for (UiMode u : hw.getSupportedUiModes()) {
            sb.append('\n').append(u.getResourceValue());
        }
        DeviceWriter.addElement(doc, hardware, "dock", sb.toString());
        DeviceWriter.addElement(doc, hardware, "power-type", hw.getChargeType().toString());
        return hardware;
    }

    private static Element generateSoftwareNode(Software sw, Document doc) {
        Element software = doc.createElement("d:software");
        String apiVersion = "";
        if (sw.getMinSdkLevel() != 0) {
            apiVersion = apiVersion + Integer.toString(sw.getMinSdkLevel());
        }
        apiVersion = apiVersion + "-";
        if (sw.getMaxSdkLevel() != Integer.MAX_VALUE) {
            apiVersion = apiVersion + Integer.toString(sw.getMaxSdkLevel());
        }
        DeviceWriter.addElement(doc, software, "api-level", apiVersion);
        DeviceWriter.addElement(doc, software, "live-wallpaper-support", Boolean.toString(sw.hasLiveWallpaperSupport()));
        DeviceWriter.addElement(doc, software, "bluetooth-profiles", sw.getBluetoothProfiles());
        DeviceWriter.addElement(doc, software, "gl-version", sw.getGlVersion());
        DeviceWriter.addElement(doc, software, "gl-extensions", sw.getGlExtensions());
        DeviceWriter.addElement(doc, software, "status-bar", Boolean.toString(sw.hasStatusBar()));
        return software;
    }

    private static Element generateStateNode(State s, Document doc, Hardware defaultHardware) {
        Element state = doc.createElement("d:state");
        state.setAttribute("name", s.getName());
        if (s.isDefaultState()) {
            state.setAttribute("default", Boolean.toString(s.isDefaultState()));
        }
        DeviceWriter.addElement(doc, state, "description", s.getDescription());
        DeviceWriter.addElement(doc, state, "screen-orientation", s.getOrientation().getResourceValue());
        DeviceWriter.addElement(doc, state, "keyboard-state", s.getKeyState().getResourceValue());
        DeviceWriter.addElement(doc, state, "nav-state", s.getNavState().getResourceValue());
        if (!s.getHardware().equals(defaultHardware)) {
            Element hardware = DeviceWriter.generateHardwareNode(s.getHardware(), doc);
            NodeList children = hardware.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                state.appendChild(child);
            }
        }
        return state;
    }

    private static Element addElement(Document doc, Element parent, String tag, String content) {
        Element child = doc.createElement(PREFIX + tag);
        child.appendChild(doc.createTextNode(content));
        parent.appendChild(child);
        return child;
    }

    private static Element addElement(Document doc, Element parent, String tag, Collection<?> content) {
        StringBuilder sb = new StringBuilder();
        for (Object o : content) {
            sb.append('\n').append(o.toString());
        }
        return DeviceWriter.addElement(doc, parent, tag, sb.toString());
    }

    private static Element addStorageElement(Document doc, Element parent, String tag, Collection<Storage> content) {
        Storage.Unit unit = Storage.Unit.TiB;
        for (Storage storage : content) {
            if (storage.getAppropriateUnits().getNumberOfBytes() >= unit.getNumberOfBytes()) continue;
            unit = storage.getAppropriateUnits();
        }
        StringBuilder sb = new StringBuilder();
        for (Storage storage3 : content) {
            sb.append('\n').append(storage3.getSizeAsUnit(unit));
        }
        Element element = DeviceWriter.addElement(doc, parent, tag, sb.toString());
        element.setAttribute("unit", unit.toString());
        return element;
    }
}

