/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SourceSearcher {
    @NonNull
    private final List<File> mSourceFolders;
    @NonNull
    private final String[] mExtensions;

    public SourceSearcher(@NonNull List<File> sourceFolders, String ... extensions) {
        this.mSourceFolders = sourceFolders;
        this.mExtensions = extensions;
    }

    public void search(@NonNull SourceFileProcessor processor) throws IOException {
        for (File file : this.mSourceFolders) {
            this.processFile(file, processor);
        }
    }

    private void processFile(@NonNull File file, @NonNull SourceFileProcessor processor) throws IOException {
        File[] children;
        if (file.isFile()) {
            String ext = this.checkExtension(file);
            if (ext != null) {
                processor.processFile(file, ext);
            }
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.processFile(child, processor);
            }
        }
    }

    private String checkExtension(@NonNull File file) {
        if (this.mExtensions.length == 0) {
            return "";
        }
        String filename = file.getName();
        int pos = filename.indexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1);
            for (String ext : this.mExtensions) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return ext;
            }
        }
        return null;
    }

    public static interface SourceFileProcessor {
        public void processFile(@NonNull File var1, @NonNull String var2) throws IOException;
    }
}

