/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.StringResourceEscaperContentHandler;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class StringResourceEscaper {
    static final String STRING_ELEMENT_NAME = "string";
    private static final Pattern DECIMAL_REFERENCE = Pattern.compile("&#(\\p{Digit}+);");
    private static final String DECIMAL_PLACEHOLDER = "___D";
    private static final Pattern HEXADECIMAL_REFERENCE = Pattern.compile("&#x(\\p{XDigit}+);");
    private static final String HEXADECIMAL_PLACEHOLDER = "___X";
    private static final Pattern ESCAPED_DECIMAL_REFERENCE = Pattern.compile("___D(\\p{Digit}+);");
    private static final Pattern ESCAPED_HEXADECIMAL_REFERENCE = Pattern.compile("___X(\\p{XDigit}+);");

    private StringResourceEscaper() {
    }

    static String escapeCharacterData(String xml) {
        if (xml.isEmpty()) {
            return "";
        }
        xml = DECIMAL_REFERENCE.matcher(xml).replaceAll("___D$1;");
        xml = HEXADECIMAL_REFERENCE.matcher(xml).replaceAll("___X$1;");
        StringBuilder builder = new StringBuilder(xml.length() * 3 / 2);
        if (StringResourceEscaper.startsOrEndsWithSpace(xml)) {
            builder.append('\"');
        } else if (StringResourceEscaper.startsWithQuestionMarkOrAtSign(xml)) {
            builder.append('\\');
        }
        try {
            StringResourceEscaper.parse(xml, builder);
        }
        catch (SAXException exception) {
            throw new IllegalArgumentException(xml, exception);
        }
        if (StringResourceEscaper.startsOrEndsWithSpace(xml)) {
            builder.append('\"');
        }
        xml = builder.toString();
        xml = ESCAPED_DECIMAL_REFERENCE.matcher(xml).replaceAll("&#$1;");
        xml = ESCAPED_HEXADECIMAL_REFERENCE.matcher(xml).replaceAll("&#x$1;");
        return xml;
    }

    private static void parse(String string, StringBuilder builder) throws SAXException {
        XMLReader reader;
        try {
            Escaper escaper = StringResourceEscaper.buildEscaper(!StringResourceEscaper.startsOrEndsWithSpace(string), false);
            StringResourceEscaperContentHandler handler = new StringResourceEscaperContentHandler(builder, escaper);
            reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (ParserConfigurationException exception) {
            throw new RuntimeException(exception);
        }
        catch (SAXException exception) {
            throw new RuntimeException(exception);
        }
        try {
            reader.parse(new InputSource(new StringReader(StringResourceEscaper.containInStringElement(string))));
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static String containInStringElement(String string) {
        return "<string>" + string + "</" + STRING_ELEMENT_NAME + ">";
    }

    static String escape(String string, boolean escapeMarkupDelimiters) {
        if (string.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(string.length() * 3 / 2);
        if (StringResourceEscaper.startsOrEndsWithSpace(string)) {
            builder.append('\"');
        } else if (StringResourceEscaper.startsWithQuestionMarkOrAtSign(string)) {
            builder.append('\\');
        }
        Escaper escaper = StringResourceEscaper.buildEscaper(!StringResourceEscaper.startsOrEndsWithSpace(string), escapeMarkupDelimiters);
        builder.append(escaper.escape(string));
        if (StringResourceEscaper.startsOrEndsWithSpace(string)) {
            builder.append('\"');
        }
        return builder.toString();
    }

    private static Escaper buildEscaper(boolean escapeApostrophes, boolean escapeMarkupDelimiters) {
        Escapers.Builder builder = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").addEscape('\t', "\\t");
        if (escapeApostrophes) {
            builder.addEscape('\'', "\\'");
        }
        if (escapeMarkupDelimiters) {
            builder.addEscape('&', "&amp;").addEscape('<', "&lt;");
        }
        return builder.build();
    }

    private static boolean startsWithQuestionMarkOrAtSign(String string) {
        assert (!string.isEmpty());
        return string.charAt(0) == '?' || string.charAt(0) == '@';
    }

    private static boolean startsOrEndsWithSpace(String string) {
        assert (!string.isEmpty());
        return string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ';
    }
}

