/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;

public class AaptCruncher
implements PngCruncher {
    private final String mAaptLocation;
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;

    public AaptCruncher(String aaptLocation, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler) {
        this.mAaptLocation = aaptLocation;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    public int start() {
        return 0;
    }

    @Override
    public ListenableFuture<File> crunchPng(int key, File from, File to) throws PngException {
        try {
            ProcessInfo processInfo = new ProcessInfoBuilder().setExecutable(this.mAaptLocation).addArgs("s", "-i", from.getAbsolutePath(), "-o", to.getAbsolutePath()).createProcess();
            ProcessResult result = this.mProcessExecutor.execute(processInfo, this.mProcessOutputHandler);
            result.rethrowFailure().assertNormalExitValue();
        }
        catch (ProcessException e) {
            throw new PngException(e);
        }
        return Futures.immediateFuture((Object)to);
    }

    @Override
    public void end(int key) throws InterruptedException {
    }
}

