/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataMerger;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.PreprocessDataFile;
import com.android.ide.common.res2.PreprocessDataItem;
import com.android.ide.common.res2.PreprocessDataSet;
import com.android.resources.Density;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreprocessResourcesMerger
extends DataMerger<PreprocessDataItem, PreprocessDataFile, PreprocessDataSet> {
    private static final String NODE_DENSITIES = "densities";
    private static final String NODE_DENSITY = "density";
    private EnumSet<Density> mDensities = EnumSet.noneOf(Density.class);
    private PreprocessDataSet mGeneratedDataSet;
    private PreprocessDataSet mMergedDataSet;

    @Override
    protected PreprocessDataSet createFromXml(Node node) throws MergingException {
        PreprocessDataSet typedHelper = new PreprocessDataSet("", PreprocessDataSet.ResourcesDirectory.GENERATED);
        return (PreprocessDataSet)typedHelper.createFromXml(node);
    }

    @Override
    protected boolean requiresMerge(@NonNull String dataItemKey) {
        return false;
    }

    @Override
    protected void mergeItems(@NonNull String dataItemKey, @NonNull List<PreprocessDataItem> items, @NonNull MergeConsumer<PreprocessDataItem> consumer) throws MergingException {
        throw new IllegalStateException("PreprocessMerger doesn't merge file contents.");
    }

    @Override
    @NonNull
    protected String getAdditionalDataTagName() {
        return NODE_DENSITIES;
    }

    @Override
    protected void loadAdditionalData(@NonNull Node densitiesNode, boolean incrementalState) throws MergingException {
        NodeList childNodes = densitiesNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(NODE_DENSITY)) continue;
            this.mDensities.add(Density.getEnum((String)child.getTextContent()));
        }
    }

    @Override
    protected void writeAdditionalData(Document document, Node rootNode) {
        Element densities = document.createElement(this.getAdditionalDataTagName());
        for (Density density : this.mDensities) {
            Element densityElement = document.createElement(NODE_DENSITY);
            densityElement.setTextContent(density.getResourceValue());
            densities.appendChild(densityElement);
        }
        rootNode.appendChild(densities);
    }

    @Override
    public void addDataSet(PreprocessDataSet resourceSet) {
        switch (resourceSet.getResourcesDirectory()) {
            case GENERATED: {
                Preconditions.checkState((this.mGeneratedDataSet == null ? 1 : 0) != 0);
                this.mGeneratedDataSet = resourceSet;
                break;
            }
            case MERGED: {
                Preconditions.checkState((this.mMergedDataSet == null ? 1 : 0) != 0);
                this.mMergedDataSet = resourceSet;
                break;
            }
            default: {
                throw new RuntimeException("Unknown data set type.");
            }
        }
        super.addDataSet(resourceSet);
    }

    public PreprocessDataSet getGeneratedDataSet() {
        return this.mGeneratedDataSet;
    }

    public PreprocessDataSet getMergedDataSet() {
        return this.mMergedDataSet;
    }

    public Set<Density> getDensities() {
        return EnumSet.copyOf(this.mDensities);
    }

    public void setDensities(Collection<Density> densities) {
        this.mDensities = EnumSet.copyOf(densities);
    }
}

