/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.util;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.util.regex.Pattern;

public class OutputLineReader {
    private static final Pattern LINE_BREAK = Pattern.compile("\\r?\\n");
    @NonNull
    private final String[] myLines;
    private final int myLineCount;
    private int myPosition;

    public OutputLineReader(@NonNull String text) {
        this.myLines = LINE_BREAK.split(text);
        this.myLineCount = this.myLines.length;
    }

    public int getLineCount() {
        return this.myLineCount;
    }

    @Nullable
    public String readLine() {
        if (this.myPosition >= 0 && this.myPosition < this.myLineCount) {
            return this.myLines[this.myPosition++];
        }
        return null;
    }

    @Nullable
    public String peek(int lineToSkipCount) {
        int tempPosition = lineToSkipCount + this.myPosition;
        if (tempPosition >= 0 && tempPosition < this.myLineCount) {
            return this.myLines[tempPosition];
        }
        return null;
    }

    public boolean hasNextLine() {
        return this.myPosition < this.myLineCount - 1;
    }

    public void skipNextLine() {
        ++this.myPosition;
    }

    public void pushBack(@NonNull String text) {
        --this.myPosition;
    }
}

