/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ToolOutputParser {
    @NonNull
    private final List<PatternAwareOutputParser> mParsers;
    @NonNull
    private final ILogger mLogger;

    public ToolOutputParser(@NonNull Iterable<PatternAwareOutputParser> parsers, @NonNull ILogger logger) {
        this.mParsers = ImmutableList.copyOf(parsers);
        this.mLogger = logger;
    }

    public ToolOutputParser(@NonNull PatternAwareOutputParser[] parsers, @NonNull ILogger logger) {
        this.mParsers = ImmutableList.copyOf((Object[])parsers);
        this.mLogger = logger;
    }

    public ToolOutputParser(@NonNull PatternAwareOutputParser parser, @NonNull ILogger logger) {
        this.mParsers = ImmutableList.of((Object)parser);
        this.mLogger = logger;
    }

    public List<Message> parseToolOutput(@NonNull String output) {
        String line;
        OutputLineReader outputReader = new OutputLineReader(output);
        if (outputReader.getLineCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList messages = Lists.newArrayList();
        while ((line = outputReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            boolean handled = false;
            for (PatternAwareOutputParser parser : this.mParsers) {
                try {
                    if (!parser.parse(line, outputReader, messages, this.mLogger)) continue;
                    handled = true;
                    break;
                }
                catch (ParsingFailedException e) {
                    return Collections.emptyList();
                }
            }
            if (handled) {
                Message last;
                int messageCount = messages.size();
                if (messageCount <= 0 || !(last = (Message)messages.get(messageCount - 1)).getText().contains("Build cancelled")) continue;
                break;
            }
            messages.add(new Message(Message.Kind.SIMPLE, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
        }
        return messages;
    }
}

