/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;

class BasicInstaller
extends AbstractInstaller {
    private static final String FN_UNZIP_DIR = "unzip";

    BasicInstaller(RemotePackage p, RepoManager mgr, Downloader downloader, FileOp fop) {
        super(p, mgr, downloader, fop);
    }

    @Override
    protected boolean doPrepare(File installTempPath, ProgressIndicator progress) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl(this.getPackage(), progress);
        if (url == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            String path = url.getPath();
            File downloadLocation = new File(installTempPath, path.substring(path.lastIndexOf(47) + 1));
            String checksum = archive.getComplete().getChecksum();
            this.getDownloader().downloadFully(url, downloadLocation, checksum, progress);
            if (progress.isCanceled()) {
                return false;
            }
            if (!this.mFop.exists(downloadLocation)) {
                progress.logWarning("Failed to download package!");
                return false;
            }
            File unzip = new File(installTempPath, FN_UNZIP_DIR);
            this.mFop.mkdirs(unzip);
            InstallerUtil.unzip(downloadLocation, unzip, this.mFop, archive.getComplete().getSize(), progress);
            if (progress.isCanceled()) {
                return false;
            }
            this.mFop.delete(downloadLocation);
            return true;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning(String.format("An error occurred while preparing SDK package %1$s%2$s", this.getPackage().getDisplayName(), message.isEmpty() ? "." : ": " + message + "."), e);
            return false;
        }
    }

    protected void cleanup(File installPath, FileOp fop) {
        fop.deleteFileOrFolder(new File(installPath, ".installer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doComplete(File installTempPath, ProgressIndicator progress) {
        if (installTempPath == null) {
            return false;
        }
        try {
            if (progress.isCanceled()) {
                boolean bl = false;
                return bl;
            }
            File unzipDir = new File(installTempPath, FN_UNZIP_DIR);
            File[] topDirContents = this.mFop.listFiles(unzipDir);
            File packageRoot = topDirContents.length != 1 ? unzipDir : topDirContents[0];
            progress.logInfo(String.format("Installing %1$s in %2$s", this.getPackage().getDisplayName(), this.getLocation(progress)));
            FileOpUtils.safeRecursiveOverwrite(packageRoot, this.getLocation(progress), this.mFop, progress);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning("An error occurred during installation" + (message.isEmpty() ? "." : ": " + message + "."), e);
        }
        finally {
            progress.setFraction(1.0);
        }
        return false;
    }
}

