/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.google.common.annotations.Beta;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlContext
extends ResourceContext {
    static final String SUPPRESS_COMMENT_PREFIX = "<!--suppress ";
    private final XmlParser parser;
    public Document document;

    public XmlContext(LintDriver driver, Project project, Project main, File file, ResourceFolderType folderType, XmlParser parser) {
        super(driver, project, main, file, folderType);
        this.parser = parser;
    }

    public Location getLocation(Node node) {
        return this.parser.getLocation(this, node);
    }

    public Location getNameLocation(Node node) {
        return this.parser.getNameLocation(this, node);
    }

    public Location getValueLocation(Attr node) {
        return this.parser.getValueLocation(this, node);
    }

    public Location getLocation(Node textNode, int begin, int end) {
        assert (textNode.getNodeType() == 3 || textNode.getNodeType() == 8);
        return this.parser.getLocation(this, textNode, begin, end);
    }

    public XmlParser getParser() {
        return this.parser;
    }

    public void report(Issue issue, Node scope, Location location, String message) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message, Object data) {
        this.report(issue, scope, location, message);
    }

    @Override
    public void report(Issue issue, Location location, String message) {
        if (this.document != null && this.driver.isSuppressed(this, issue, this.document)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Override
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressedWithComment(Node node, Issue issue) {
        CharSequence contents = this.getContents();
        assert (contents != null);
        int start = this.parser.getNodeStartOffset(this, node);
        if (start != -1) {
            return this.isSuppressedWithComment(start, issue);
        }
        return false;
    }

    public Location.Handle createLocationHandle(Node node) {
        return this.parser.createLocationHandle(this, node);
    }
}

