/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import java.io.File;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.Position;

public class JavaContext
extends Context {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    public Node compilationUnit;
    public IJavaParser parser;

    public JavaContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file) {
        super(driver, project, main, file);
    }

    @NonNull
    public Location getLocation(@NonNull Node node) {
        if (this.parser != null) {
            return this.parser.getLocation(this, node);
        }
        return new Location(this.file, null, null);
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (this.mDriver.isSuppressed(this, issue, this.compilationUnit)) {
            return;
        }
        super.report(issue, location, message, data);
    }

    public void report(@NonNull Issue issue, @Nullable Node scope, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message, data);
    }

    @Nullable
    public static Node findSurroundingMethod(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Nullable
    public static ClassDeclaration findSurroundingClass(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == ClassDeclaration.class) {
                return (ClassDeclaration)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Override
    @Nullable
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressed(@NonNull Node scope, @NonNull Issue issue) {
        String contents = this.getContents();
        assert (contents != null);
        Position position = scope.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getStart();
        return this.isSuppressedWithComment(start, issue);
    }
}

