/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.DexFileNameSupplier;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

class DexIncrementalRenameManager
implements Closeable {
    private static final String STATE_FILE = "dex-renamer-state.txt";
    private static final String BASE_KEY_PREFIX = "base.";
    private static final String FILE_KEY_PREFIX = "file.";
    private static final String RENAMED_KEY_PREFIX = "renamed.";
    private final BiMap<RelativeFile, String> mNameMap;
    private final File mIncrementalDir;
    private boolean mClosed;

    DexIncrementalRenameManager(File incrementalDir) throws IOException {
        Preconditions.checkArgument((boolean)incrementalDir.isDirectory(), (Object)"!incrementalDir.isDirectory()");
        this.mNameMap = HashBiMap.create();
        this.mIncrementalDir = incrementalDir;
        this.mClosed = false;
        this.readState();
    }

    private void readState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        if (!stateFile.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (Closer closer = Closer.create();){
            props.load((Reader)closer.register((Closeable)new FileReader(stateFile)));
        }
        int i = 0;
        while (true) {
            String baseKey = BASE_KEY_PREFIX + i;
            String fileKey = FILE_KEY_PREFIX + i;
            String renamedKey = RENAMED_KEY_PREFIX + i;
            String base = props.getProperty(baseKey);
            String file = props.getProperty(fileKey);
            String rename = props.getProperty(renamedKey);
            if (base == null || file == null || rename == null) break;
            RelativeFile rf = new RelativeFile(new File(base), new File(file));
            this.mNameMap.put((Object)rf, (Object)rename);
            ++i;
        }
    }

    private void writeState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        Properties props = new Properties();
        int currIdx = 0;
        for (Map.Entry entry : this.mNameMap.entrySet()) {
            props.put(BASE_KEY_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getBase().getPath());
            props.put(FILE_KEY_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getFile().getPath());
            props.put(RENAMED_KEY_PREFIX + currIdx, entry.getValue());
            ++currIdx;
        }
        try (Closer closer = Closer.create();){
            props.store((Writer)closer.register((Closeable)new FileWriter(stateFile)), null);
        }
    }

    Set<PackagedFileUpdate> update(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        RelativeFile file;
        RelativeFile mappingToClassesDex;
        LinkedList nameList = Lists.newLinkedList();
        DexFileNameSupplier nameSupplier = new DexFileNameSupplier();
        for (int i = 0; i < this.mNameMap.size(); ++i) {
            String nextName = nameSupplier.get();
            nameList.add(nextName);
            Verify.verify((boolean)this.mNameMap.containsValue((Object)nextName), (String)("mNameMap does not contain '" + nextName + "', but has a total of " + this.mNameMap.size() + " entries {mNameMap = " + this.mNameMap + "}"), (Object[])new Object[0]);
        }
        LinkedList deletedNames = Lists.newLinkedList();
        HashMap deletedFiles = Maps.newHashMap();
        for (RelativeFile deletedRf : Maps.filterValues(files, (Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)).keySet()) {
            String deletedName = (String)this.mNameMap.get((Object)deletedRf);
            if (deletedName == null) {
                throw new IOException("Incremental update refers to relative file '" + deletedRf + "' as deleted, but this file is not known.");
            }
            if (deletedName.equals("classes.dex")) {
                deletedNames.addFirst(deletedName);
            } else {
                deletedNames.add(deletedName);
            }
            deletedFiles.put(deletedName, deletedRf);
            this.mNameMap.remove((Object)deletedRf);
        }
        AtomicBoolean addingClassesDex = new AtomicBoolean(false);
        LinkedList addedFiles = Lists.newLinkedList((Iterable)Maps.filterValues(files, (Predicate)Predicates.equalTo((Object)FileStatus.NEW)).keySet().stream().peek(rf -> {
            if (DexIncrementalRenameManager.getOsIndependentFileName(rf).equals("classes.dex")) {
                addingClassesDex.set(true);
            }
        }).sorted(new DexNameComparator()).collect(Collectors.toList()));
        if (addingClassesDex.get() && (mappingToClassesDex = (RelativeFile)this.mNameMap.inverse().get((Object)"classes.dex")) != null && !DexIncrementalRenameManager.getOsIndependentFileName(mappingToClassesDex).equals("classes.dex")) {
            this.mNameMap.remove((Object)mappingToClassesDex);
            addedFiles.add(mappingToClassesDex);
            deletedNames.add("classes.dex");
        }
        HashSet addedNames = Sets.newHashSet();
        HashSet updatedNames = Sets.newHashSet();
        Iterator deletedNamesIterator = deletedNames.iterator();
        for (RelativeFile addedRf : addedFiles) {
            if (deletedNamesIterator.hasNext()) {
                String toUse = (String)deletedNamesIterator.next();
                deletedNamesIterator.remove();
                deletedFiles.remove(toUse);
                updatedNames.add(toUse);
                this.mNameMap.put((Object)addedRf, (Object)toUse);
                continue;
            }
            String addedName = nameSupplier.get();
            addedNames.add(addedName);
            nameList.add(addedName);
            this.mNameMap.put((Object)addedRf, (Object)addedName);
        }
        for (RelativeFile updatedRf : Maps.filterValues(files, (Predicate)Predicates.equalTo((Object)FileStatus.CHANGED)).keySet()) {
            String updatedName = (String)this.mNameMap.get((Object)updatedRf);
            if (updatedName == null) {
                throw new IOException("Incremental update refers to relative file '" + updatedRf + "' as updated, but this file is not known.");
            }
            updatedNames.add(updatedName);
        }
        HashSet finallyDeletedNames = Sets.newHashSet();
        while (!deletedNames.isEmpty()) {
            if (((String)deletedNames.getLast()).equals(nameList.getLast())) {
                nameList.removeLast();
                finallyDeletedNames.add(deletedNames.removeLast());
                continue;
            }
            String lastInNames = (String)nameList.removeLast();
            String firstInDeleted = (String)deletedNames.remove();
            finallyDeletedNames.add(lastInNames);
            updatedNames.remove(lastInNames);
            updatedNames.add(firstInDeleted);
            RelativeFile file2 = (RelativeFile)this.mNameMap.inverse().get((Object)lastInNames);
            Verify.verifyNotNull((Object)file2, (String)"file == null", (Object[])new Object[0]);
            this.mNameMap.put((Object)file2, (Object)firstInDeleted);
            deletedFiles.put(lastInNames, file2);
        }
        HashSet updates = Sets.newHashSet();
        for (String addedName : addedNames) {
            file = (RelativeFile)Verify.verifyNotNull((Object)this.mNameMap.inverse().get((Object)addedName));
            updates.add(new PackagedFileUpdate(file, addedName, FileStatus.NEW));
        }
        for (String updatedName : updatedNames) {
            file = (RelativeFile)Verify.verifyNotNull((Object)this.mNameMap.inverse().get((Object)updatedName));
            updates.add(new PackagedFileUpdate(file, updatedName, FileStatus.CHANGED));
        }
        for (String deletedName : finallyDeletedNames) {
            file = (RelativeFile)Verify.verifyNotNull(deletedFiles.get(deletedName));
            updates.add(new PackagedFileUpdate(file, deletedName, FileStatus.REMOVED));
        }
        return updates;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.writeState();
    }

    private static String getOsIndependentFileName(RelativeFile file) {
        String[] pathSplit = file.getOsIndependentRelativePath().split("/");
        return pathSplit[pathSplit.length - 1];
    }

    private static class DexNameComparator
    implements Comparator<RelativeFile> {
        private DexNameComparator() {
        }

        @Override
        public int compare(RelativeFile f1, RelativeFile f2) {
            String s1 = f1.getOsIndependentRelativePath();
            String s2 = f2.getOsIndependentRelativePath();
            if (s1.equals("classes.dex")) {
                return -1;
            }
            if (s2.equals("classes.dex")) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

