/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.jack.api.JackProvider;
import com.android.jill.api.JillProvider;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public enum BuildToolsServiceLoader {
    INSTANCE;

    private final List<LoadedBuildTool> loadedBuildTools = new ArrayList<LoadedBuildTool>();
    public static final Service<JackProvider> JACK;
    public static final Service<JillProvider> JILL;

    public synchronized BuildToolServiceLoader forVersion(BuildToolInfo buildToolInfo) {
        Optional<LoadedBuildTool> loadedBuildToolOptional = this.findVersion(buildToolInfo.getRevision());
        if (loadedBuildToolOptional.isPresent()) {
            return loadedBuildToolOptional.get().serviceLoader;
        }
        LoadedBuildTool loadedBuildTool = new LoadedBuildTool(buildToolInfo.getRevision(), new BuildToolServiceLoader(buildToolInfo));
        this.loadedBuildTools.add(loadedBuildTool);
        return loadedBuildTool.serviceLoader;
    }

    private Optional<LoadedBuildTool> findVersion(Revision version) {
        for (LoadedBuildTool loadedBuildTool : this.loadedBuildTools) {
            if (!loadedBuildTool.version.equals((Object)version)) continue;
            return Optional.of(loadedBuildTool);
        }
        return Optional.empty();
    }

    static {
        JACK = new Service<JackProvider>((Collection<String>)ImmutableList.of((Object)"jack.jar"), JackProvider.class);
        JILL = new Service<JillProvider>((Collection<String>)ImmutableList.of((Object)"jill.jar"), JillProvider.class);
    }

    private static class ApiClassLoader
    extends ClassLoader {
        private final String mApiPackage;
        private final ClassLoader mApiClassLoader;

        public ApiClassLoader(Class<?> apiClass) {
            super(ClassLoader.getSystemClassLoader());
            this.mApiPackage = apiClass.getPackage().getName();
            this.mApiClassLoader = apiClass.getClassLoader();
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith(this.mApiPackage)) {
                return this.mApiClassLoader.loadClass(name);
            }
            return ClassLoader.getSystemClassLoader().loadClass(name);
        }
    }

    public static final class BuildToolServiceLoader {
        private final BuildToolInfo buildToolInfo;
        private final List<LoadedServiceLoader> loadedServicesLoaders = new ArrayList<LoadedServiceLoader>();

        private BuildToolServiceLoader(BuildToolInfo buildToolInfo) {
            this.buildToolInfo = buildToolInfo;
        }

        public synchronized <T> ServiceLoader<T> getServiceLoader(Service<T> serviceType) throws ClassNotFoundException {
            Optional<ServiceLoader<T>> serviceLoaderOptional = this.getLoadedServiceLoader(serviceType.getServiceClass());
            if (serviceLoaderOptional.isPresent()) {
                return serviceLoaderOptional.get();
            }
            File buildToolLocation = this.buildToolInfo.getLocation();
            if (System.getenv("USE_JACK_LOCATION") != null) {
                buildToolLocation = new File(System.getenv("USE_JACK_LOCATION"));
            }
            URL[] urls = new URL[((Service)serviceType).classpath.size()];
            int i = 0;
            for (String classpathItem : serviceType.getClasspath()) {
                File jarFile = new File(buildToolLocation, classpathItem);
                try {
                    urls[i++] = jarFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            ApiClassLoader apiLoader = new ApiClassLoader(serviceType.getServiceClass());
            URLClassLoader cl = new URLClassLoader(urls, (ClassLoader)apiLoader);
            ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType.getServiceClass(), cl);
            this.loadedServicesLoaders.add(new LoadedServiceLoader(serviceType.getServiceClass(), serviceLoader));
            return serviceLoader;
        }

        public synchronized <T> Optional<T> getSingleService(ILogger logger, Service<T> serviceType) throws ClassNotFoundException {
            logger.verbose("Looking for %1$s", new Object[]{serviceType});
            ServiceLoader<T> serviceLoader = this.getServiceLoader(serviceType);
            logger.verbose("Got a serviceLoader %1$s", new Object[]{Integer.toHexString(System.identityHashCode(serviceLoader))});
            Iterator<T> serviceIterator = serviceLoader.iterator();
            logger.verbose("Service Iterator =  %1$s ", new Object[]{serviceIterator});
            if (serviceIterator.hasNext()) {
                T service = serviceIterator.next();
                logger.verbose("Got it from %1$s, loaded service = %2$s, type = %3$s", new Object[]{serviceIterator, service, service.getClass()});
                return Optional.of(service);
            }
            logger.verbose("Cannot find service implementation %1$s", new Object[]{serviceType});
            return Optional.empty();
        }

        private <T> Optional<ServiceLoader<T>> getLoadedServiceLoader(Class<T> serviceType) {
            for (LoadedServiceLoader loadedServiceLoader : this.loadedServicesLoaders) {
                if (!loadedServiceLoader.serviceType.equals(serviceType)) continue;
                return Optional.of(loadedServiceLoader.serviceLoader);
            }
            return Optional.empty();
        }

        private static final class LoadedServiceLoader<T> {
            private final Class<T> serviceType;
            private final ServiceLoader<T> serviceLoader;

            private LoadedServiceLoader(Class<T> serviceType, ServiceLoader<T> serviceLoader) {
                this.serviceType = serviceType;
                this.serviceLoader = serviceLoader;
            }
        }
    }

    public static class Service<T> {
        private final Collection<String> classpath;
        private final Class<T> serviceClass;

        protected Service(Collection<String> classpath, Class<T> serviceClass) {
            this.classpath = classpath;
            this.serviceClass = serviceClass;
        }

        public Collection<String> getClasspath() {
            return this.classpath;
        }

        public Class<T> getServiceClass() {
            return this.serviceClass;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("serviceClass", this.serviceClass).add("classpath", (Object)Joiner.on((String)",").join(this.classpath)).toString();
        }
    }

    private static final class LoadedBuildTool {
        private final Revision version;
        private final BuildToolServiceLoader serviceLoader;

        private LoadedBuildTool(Revision version, BuildToolServiceLoader serviceLoader) {
            this.version = version;
            this.serviceLoader = serviceLoader;
        }
    }
}

