/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.sign.v2;

import com.android.apkzlib.sign.v2.DigestSource;
import com.android.apkzlib.zip.ZFile;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.MessageDigest;
import javax.annotation.Nonnull;

public class ZFileDigestSource
implements DigestSource {
    private final ZFile mFile;
    private final long mOffset;
    private final long mSize;

    public ZFileDigestSource(@Nonnull ZFile file, long offset, long size) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset: %s", (Object[])new Object[]{offset});
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"size: %s", (Object[])new Object[]{size});
        this.mFile = file;
        this.mOffset = offset;
        this.mSize = size;
    }

    @Override
    public long size() {
        return this.mSize;
    }

    @Override
    public void feedDigests(long offset, int size, @Nonnull MessageDigest[] digests) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset: %s", (Object[])new Object[]{offset});
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"size: %s", (Object[])new Object[]{size});
        Preconditions.checkArgument((offset <= this.mSize ? 1 : 0) != 0, (String)"offset: %s, file size: %s", (Object[])new Object[]{offset, this.mSize});
        long chunkStartOffset = this.mOffset + offset;
        long availableSize = this.mSize - offset;
        Preconditions.checkArgument(((long)size <= availableSize ? 1 : 0) != 0, (String)"offset: %s, size: %s, file size: %s", (Object[])new Object[]{offset, size, this.mSize});
        byte[] chunk = new byte[size];
        this.mFile.directFullyRead(chunkStartOffset, chunk);
        for (MessageDigest md : digests) {
            md.update(chunk);
        }
    }
}

