/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker.parser;

import com.android.builder.shrinker.parser.AnnotationSpecification;
import com.android.builder.shrinker.parser.ClassSpecification;
import com.android.builder.shrinker.parser.ClassTypeSpecification;
import com.android.builder.shrinker.parser.FieldSpecification;
import com.android.builder.shrinker.parser.FilterSpecification;
import com.android.builder.shrinker.parser.Flags;
import com.android.builder.shrinker.parser.InheritanceSpecification;
import com.android.builder.shrinker.parser.KeepModifier;
import com.android.builder.shrinker.parser.MethodSpecification;
import com.android.builder.shrinker.parser.ModifierSpecification;
import com.android.builder.shrinker.parser.NameSpecification;
import com.android.builder.shrinker.parser.ProguardLexer;
import com.android.builder.shrinker.parser.ProguardParser;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class GrammarActions {
    public static void parse(String proguardFileName, String baseDir, Flags flags) throws RecognitionException {
        File proguardFile = GrammarActions.getFileFromBaseDir(baseDir, proguardFileName);
        ProguardParser parser = GrammarActions.createParserFromFile(proguardFile);
        if (parser != null) {
            parser.prog(flags, proguardFile.getParentFile().getPath());
        }
    }

    static void addKeepClassMembers(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        if (keepModifier == null) {
            keepModifier = KeepModifier.NONE;
        }
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassMembers(classSpecification);
    }

    static void addKeepClassSpecification(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        if (keepModifier == null) {
            keepModifier = KeepModifier.NONE;
        }
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassSpecification(classSpecification);
    }

    static void addKeepClassesWithMembers(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        if (keepModifier == null) {
            keepModifier = KeepModifier.NONE;
        }
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassesWithMembers(classSpecification);
    }

    static void addModifier(ModifierSpecification modSpec, int modifier, boolean hasNegator) {
        modSpec.addModifier(modifier, hasNegator);
    }

    static AnnotationSpecification annotation(String annotationName, boolean hasNameNegator) {
        NameSpecification name = GrammarActions.name(annotationName);
        name.setNegator(hasNameNegator);
        return new AnnotationSpecification(name);
    }

    static ClassSpecification classSpec(String name, boolean hasNameNegator, ClassTypeSpecification classType, AnnotationSpecification annotation, ModifierSpecification modifier) {
        NameSpecification nameSpec = name.equals("*") ? GrammarActions.name("**") : GrammarActions.name(name);
        nameSpec.setNegator(hasNameNegator);
        ClassSpecification classSpec = new ClassSpecification(nameSpec, classType, annotation);
        classSpec.setModifier(modifier);
        return classSpec;
    }

    static ClassTypeSpecification classType(int type, boolean hasNegator) {
        ClassTypeSpecification classSpec = new ClassTypeSpecification(type);
        classSpec.setNegator(hasNegator);
        return classSpec;
    }

    static InheritanceSpecification createInheritance(String className, boolean hasNameNegator, AnnotationSpecification annotationType) {
        NameSpecification nameSpec = GrammarActions.name(className);
        nameSpec.setNegator(hasNameNegator);
        return new InheritanceSpecification(nameSpec, annotationType);
    }

    static void field(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSignature, String name, ModifierSpecification modifier) {
        NameSpecification typeSignatureSpec = null;
        if (typeSignature != null) {
            typeSignatureSpec = GrammarActions.name(typeSignature);
        } else {
            Preconditions.checkState((boolean)name.equals("*"), (Object)"No type signature, but name is not <fields> or *.");
            name = "*";
        }
        classSpec.add(new FieldSpecification(GrammarActions.name(name), modifier, typeSignatureSpec, annotationType));
    }

    static void fieldOrAnyMember(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSig, String name, ModifierSpecification modifier) {
        if (typeSig == null) {
            assert (name.equals("*"));
            GrammarActions.method(classSpec, annotationType, GrammarActions.getSignature("***", 0), "*", "(" + GrammarActions.getSignature("...", 0) + ")", modifier);
        }
        GrammarActions.field(classSpec, annotationType, typeSig, name, modifier);
    }

    static void filter(FilterSpecification filter, boolean negator, String filterName) {
        filter.addElement(GrammarActions.name(filterName), negator);
    }

    static String getSignature(String name, int dim) {
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i < dim; ++i) {
            sig.append("\\[");
        }
        if (name.equals("...")) {
            sig.append(".*");
        } else if (name.equals("***")) {
            sig.append(".*");
        } else if (name.equals("%")) {
            sig.append("(Z|B|C|S|I|F|D|L)");
        } else if (name.equals("boolean")) {
            sig.append("Z");
        } else if (name.equals("byte")) {
            sig.append("B");
        } else if (name.equals("char")) {
            sig.append("C");
        } else if (name.equals("short")) {
            sig.append("S");
        } else if (name.equals("int")) {
            sig.append("I");
        } else if (name.equals("float")) {
            sig.append("F");
        } else if (name.equals("double")) {
            sig.append("D");
        } else if (name.equals("long")) {
            sig.append("J");
        } else if (name.equals("void")) {
            sig.append("V");
        } else {
            sig.append("L").append(GrammarActions.convertNameToPattern(name)).append(";");
        }
        return sig.toString();
    }

    static void method(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSig, String name, String signature, ModifierSpecification modifier) {
        String fullName = "^" + GrammarActions.convertNameToPattern(name);
        fullName = fullName + ":";
        fullName = fullName + signature.replace("(", "\\(").replace(")", "\\)");
        fullName = typeSig != null ? fullName + typeSig : fullName + "V";
        fullName = fullName + "$";
        Pattern pattern = Pattern.compile(fullName);
        classSpec.add(new MethodSpecification(new NameSpecification(pattern), modifier, annotationType));
    }

    static NameSpecification name(String name) {
        String transformedName = "^" + GrammarActions.convertNameToPattern(name) + "$";
        Pattern pattern = Pattern.compile(transformedName);
        return new NameSpecification(pattern);
    }

    static void unsupportedFlag(String flag) {
        throw new IllegalArgumentException(String.format("Flag %s is not supported by the custom shrinker.", flag));
    }

    private static String convertNameToPattern(String name) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('/');
                    continue block6;
                }
                case '?': {
                    sb.append("[^/]");
                    continue block6;
                }
                case '*': {
                    int j = i + 1;
                    if (j < name.length() && name.charAt(j) == '*') {
                        sb.append(".*");
                        ++i;
                        continue block6;
                    }
                    sb.append("[^/]*");
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static ProguardParser createParserCommon(CharStream stream) {
        ProguardLexer lexer = new ProguardLexer(stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new ProguardParser((TokenStream)tokens);
    }

    private static ProguardParser createParserFromFile(File file) {
        try {
            return GrammarActions.createParserCommon((CharStream)new ANTLRFileStream(file.getPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getFileFromBaseDir(String baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }
}

