/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.ManifestParser;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildType;
import com.android.builder.model.ClassField;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.ResourceSet;
import com.android.utils.StringHelper;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantConfiguration<T extends BuildType, D extends ProductFlavor, F extends ProductFlavor> {
    private final ManifestParser sManifestParser = new DefaultManifestParser();
    private String mFullName;
    private String mFlavorName;
    private String mBaseName;
    private String mDirName;
    private List<String> mDirSegments;
    private final D mDefaultConfig;
    private final SourceProvider mDefaultSourceProvider;
    private final T mBuildType;
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<String> mFlavorDimensionNames = Lists.newArrayList();
    private final List<F> mFlavors = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    private SourceProvider mVariantSourceProvider;
    private SourceProvider mMultiFlavorSourceProvider;
    private final VariantType mType;
    private final VariantConfiguration<T, D, F> mTestedConfig;
    private LibraryDependency mOutput;
    private ProductFlavor mMergedFlavor;
    private final Set<JarDependency> mExternalJars = Sets.newHashSet();
    private final Set<JarDependency> mLocalJars = Sets.newHashSet();
    private final List<LibraryDependency> mDirectLibraries = Lists.newArrayList();
    private final List<LibraryDependency> mFlatLibraries = Lists.newArrayList();
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final SigningConfig mSigningConfigOverride;
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";
    private static final String MULTIDEX_TEST_RUNNER = "com.android.test.runner.MultiDexTestRunner";
    private static final Boolean DEFAULT_HANDLE_PROFILING = false;
    private static final Boolean DEFAULT_FUNCTIONAL_TEST = false;

    public static String getManifestPackage(File manifestFile) {
        return new DefaultManifestParser().getPackage(manifestFile);
    }

    public VariantConfiguration(D defaultConfig, SourceProvider defaultSourceProvider, T buildType, SourceProvider buildTypeSourceProvider, VariantType type, SigningConfig signingConfigOverride) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, null, signingConfigOverride);
    }

    public VariantConfiguration(D defaultConfig, SourceProvider defaultSourceProvider, T buildType, SourceProvider buildTypeSourceProvider, VariantType type, VariantConfiguration<T, D, F> testedConfig, SigningConfig signingConfigOverride) {
        Preconditions.checkNotNull(defaultConfig);
        Preconditions.checkNotNull((Object)defaultSourceProvider);
        Preconditions.checkNotNull(buildType);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkArgument((!type.isForTesting() || testedConfig != null ? 1 : 0) != 0, (Object)"You have to specify the tested variant for this variant type.");
        Preconditions.checkArgument((type.isForTesting() || testedConfig == null ? 1 : 0) != 0, (Object)"This variant type doesn't need a tested variant.");
        this.mDefaultConfig = (ProductFlavor)Preconditions.checkNotNull(defaultConfig);
        this.mDefaultSourceProvider = (SourceProvider)Preconditions.checkNotNull((Object)defaultSourceProvider);
        this.mBuildType = (BuildType)Preconditions.checkNotNull(buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = (VariantType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mTestedConfig = testedConfig;
        this.mSigningConfigOverride = signingConfigOverride;
        this.mMergedFlavor = DefaultProductFlavor.clone(this.mDefaultConfig);
    }

    public String getFullName() {
        if (this.mFullName == null) {
            StringBuilder sb = new StringBuilder();
            String flavorName = this.getFlavorName();
            if (!flavorName.isEmpty()) {
                sb.append(flavorName);
                sb.append(StringHelper.capitalize((String)this.mBuildType.getName()));
            } else {
                sb.append(this.mBuildType.getName());
            }
            if (this.mType.isForTesting()) {
                sb.append(this.mType.getSuffix());
            }
            this.mFullName = sb.toString();
        }
        return this.mFullName;
    }

    public String computeFullNameWithSplits(String splitName) {
        StringBuilder sb = new StringBuilder();
        String flavorName = this.getFlavorName();
        if (!flavorName.isEmpty()) {
            sb.append(flavorName);
            sb.append(StringHelper.capitalize((String)splitName));
        } else {
            sb.append(splitName);
        }
        sb.append(StringHelper.capitalize((String)this.mBuildType.getName()));
        if (this.mType.isForTesting()) {
            sb.append(this.mType.getSuffix());
        }
        return sb.toString();
    }

    public String getFlavorName() {
        if (this.mFlavorName == null) {
            if (this.mFlavors.isEmpty()) {
                this.mFlavorName = "";
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (ProductFlavor flavor : this.mFlavors) {
                    sb.append(first ? flavor.getName() : StringHelper.capitalize((String)flavor.getName()));
                    first = false;
                }
                this.mFlavorName = sb.toString();
            }
        }
        return this.mFlavorName;
    }

    public String getBaseName() {
        if (this.mBaseName == null) {
            StringBuilder sb = new StringBuilder();
            if (!this.mFlavors.isEmpty()) {
                for (ProductFlavor pf : this.mFlavors) {
                    sb.append(pf.getName()).append('-');
                }
            }
            sb.append(this.mBuildType.getName());
            if (this.mType.isForTesting()) {
                sb.append('-').append(this.mType.getPrefix());
            }
            this.mBaseName = sb.toString();
        }
        return this.mBaseName;
    }

    public String computeBaseNameWithSplits(String splitName) {
        StringBuilder sb = new StringBuilder();
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor pf : this.mFlavors) {
                sb.append(pf.getName()).append('-');
            }
        }
        sb.append(splitName).append('-');
        sb.append(this.mBuildType.getName());
        if (this.mType.isForTesting()) {
            sb.append('-').append(this.mType.getPrefix());
        }
        return sb.toString();
    }

    public String getDirName() {
        if (this.mDirName == null) {
            StringBuilder sb = new StringBuilder();
            if (this.mType.isForTesting()) {
                sb.append(this.mType.getPrefix()).append("/");
            }
            if (!this.mFlavors.isEmpty()) {
                boolean first = true;
                for (ProductFlavor flavor : this.mFlavors) {
                    sb.append(first ? flavor.getName() : StringHelper.capitalize((String)flavor.getName()));
                    first = false;
                }
                sb.append('/').append(this.mBuildType.getName());
            } else {
                sb.append(this.mBuildType.getName());
            }
            this.mDirName = sb.toString();
        }
        return this.mDirName;
    }

    public Collection<String> getDirectorySegments() {
        if (this.mDirSegments == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.mType.isForTesting()) {
                builder.add((Object)this.mType.getPrefix());
            }
            if (!this.mFlavors.isEmpty()) {
                StringBuilder sb = new StringBuilder(this.mFlavors.size() * 10);
                for (ProductFlavor flavor : this.mFlavors) {
                    StringHelper.appendCamelCase((StringBuilder)sb, (String)flavor.getName());
                }
                builder.add((Object)sb.toString());
                builder.add((Object)this.mBuildType.getName());
            } else {
                builder.add((Object)this.mBuildType.getName());
            }
            this.mDirSegments = builder.build();
        }
        return this.mDirSegments;
    }

    public String computeDirNameWithSplits(String ... splitNames) {
        StringBuilder sb = new StringBuilder();
        if (this.mType.isForTesting()) {
            sb.append(this.mType.getPrefix()).append("/");
        }
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor flavor : this.mFlavors) {
                sb.append(flavor.getName());
            }
            sb.append('/');
        }
        for (String splitName : splitNames) {
            if (splitName == null) continue;
            sb.append(splitName).append('/');
        }
        sb.append(this.mBuildType.getName());
        return sb.toString();
    }

    public List<String> getFlavorNamesWithDimensionNames() {
        List<Object> names;
        if (this.mFlavors.isEmpty()) {
            return Collections.emptyList();
        }
        int count = this.mFlavors.size();
        if (count > 1) {
            names = Lists.newArrayListWithCapacity((int)(count * 2));
            for (int i = 0; i < count; ++i) {
                names.add(((ProductFlavor)this.mFlavors.get(i)).getName());
                names.add(this.mFlavorDimensionNames.get(i));
            }
        } else {
            names = Collections.singletonList(((ProductFlavor)this.mFlavors.get(0)).getName());
        }
        return names;
    }

    public VariantConfiguration addProductFlavor(F productFlavor, SourceProvider sourceProvider, String dimensionName) {
        this.mFlavors.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mFlavorDimensionNames.add(dimensionName);
        this.mMergedFlavor = DefaultProductFlavor.mergeFlavors(this.mMergedFlavor, productFlavor);
        return this;
    }

    public VariantConfiguration setVariantSourceProvider(SourceProvider sourceProvider) {
        this.mVariantSourceProvider = sourceProvider;
        return this;
    }

    public VariantConfiguration setMultiFlavorSourceProvider(SourceProvider sourceProvider) {
        this.mMultiFlavorSourceProvider = sourceProvider;
        return this;
    }

    public SourceProvider getVariantSourceProvider() {
        return this.mVariantSourceProvider;
    }

    public SourceProvider getMultiFlavorSourceProvider() {
        return this.mMultiFlavorSourceProvider;
    }

    public VariantConfiguration setDependencies(DependencyContainer container) {
        if (this.mTestedConfig != null && this.mTestedConfig.mType == VariantType.LIBRARY && this.mTestedConfig.mOutput != null && !this.mDirectLibraries.contains(this.mTestedConfig.mOutput)) {
            this.mDirectLibraries.add(this.mTestedConfig.mOutput);
        }
        this.mDirectLibraries.addAll(container.getAndroidDependencies());
        this.mExternalJars.addAll(container.getJarDependencies());
        this.mLocalJars.addAll(container.getLocalDependencies());
        VariantConfiguration.resolveIndirectLibraryDependencies(this.mDirectLibraries, this.mFlatLibraries);
        return this;
    }

    public Collection<JarDependency> getExternalJarDependencies() {
        return this.mExternalJars;
    }

    public Collection<JarDependency> getLocalJarDependencies() {
        return this.mLocalJars;
    }

    public VariantConfiguration setOutput(LibraryDependency output) {
        this.mOutput = output;
        return this;
    }

    public LibraryDependency getOutput() {
        return this.mOutput;
    }

    public D getDefaultConfig() {
        return this.mDefaultConfig;
    }

    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    public ProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    public T getBuildType() {
        return this.mBuildType;
    }

    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavors.isEmpty();
    }

    public List<F> getProductFlavors() {
        return this.mFlavors;
    }

    public List<SourceProvider> getFlavorSourceProviders() {
        return this.mFlavorSourceProviders;
    }

    public List<LibraryDependency> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    public List<LibraryDependency> getAllLibraries() {
        return this.mFlatLibraries;
    }

    public VariantType getType() {
        return this.mType;
    }

    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    static void resolveIndirectLibraryDependencies(List<LibraryDependency> directDependencies, List<LibraryDependency> outFlatDependencies) {
        if (directDependencies == null) {
            return;
        }
        for (int i = directDependencies.size() - 1; i >= 0; --i) {
            LibraryDependency library = directDependencies.get(i);
            List<LibraryDependency> dependencies = library.getDependencies();
            ArrayList depList = Lists.newArrayList(dependencies);
            VariantConfiguration.resolveIndirectLibraryDependencies(depList, outFlatDependencies);
            if (outFlatDependencies.contains(library)) continue;
            outFlatDependencies.add(0, library);
        }
    }

    public String getOriginalApplicationId() {
        if (this.mType.isForTesting()) {
            return this.getApplicationId();
        }
        return this.getPackageFromManifest();
    }

    public String getApplicationId() {
        String id;
        if (this.mType.isForTesting()) {
            Preconditions.checkState((this.mTestedConfig != null ? 1 : 0) != 0);
            id = this.mMergedFlavor.getTestApplicationId();
            String testedPackage = this.mTestedConfig.getApplicationId();
            if (id == null) {
                id = testedPackage + ".test";
            } else if (id.equals(testedPackage)) {
                throw new RuntimeException(String.format("Application and test application id cannot be the same: both are '%s' for %s", id, this.getFullName()));
            }
        } else {
            id = this.getIdOverride();
            if (id == null) {
                id = this.getPackageFromManifest();
            }
        }
        if (id == null) {
            throw new RuntimeException("Failed to get application id for " + this.getFullName());
        }
        return id;
    }

    public String getTestedApplicationId() {
        if (this.mType.isForTesting()) {
            Preconditions.checkState((this.mTestedConfig != null ? 1 : 0) != 0);
            if (this.mTestedConfig.mType == VariantType.LIBRARY) {
                return this.getApplicationId();
            }
            return this.mTestedConfig.getApplicationId();
        }
        return null;
    }

    public String getIdOverride() {
        String idName = this.mMergedFlavor.getApplicationId();
        String idSuffix = (String)Objects.firstNonNull((Object)this.mMergedFlavor.getApplicationIdSuffix(), (Object)"");
        String buildTypeIdSuffix = this.mBuildType.getApplicationIdSuffix();
        if (!Strings.isNullOrEmpty((String)buildTypeIdSuffix)) {
            idSuffix = buildTypeIdSuffix.charAt(0) == '.' ? idSuffix + buildTypeIdSuffix : idSuffix + '.' + buildTypeIdSuffix;
        }
        if (!idSuffix.isEmpty()) {
            if (idName == null) {
                idName = this.getPackageFromManifest();
            }
            idName = idSuffix.charAt(0) == '.' ? idName + idSuffix : idName + '.' + idSuffix;
        }
        return idName;
    }

    public String getVersionName() {
        String versionName = this.mMergedFlavor.getVersionName();
        String versionSuffix = this.mBuildType.getVersionNameSuffix();
        if (versionName == null && !this.mType.isForTesting()) {
            versionName = this.getVersionNameFromManifest();
        }
        if (versionSuffix != null && !versionSuffix.isEmpty()) {
            versionName = Strings.nullToEmpty((String)versionName) + versionSuffix;
        }
        return versionName;
    }

    public int getVersionCode() {
        int versionCode;
        int n = versionCode = this.mMergedFlavor.getVersionCode() != null ? this.mMergedFlavor.getVersionCode() : -1;
        if (versionCode == -1 && !this.mType.isForTesting()) {
            versionCode = this.getVersionCodeFromManifest();
        }
        return versionCode;
    }

    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config = this;
        if (this.mType.isForTesting()) {
            config = this.getTestedConfig();
            Preconditions.checkState((config != null ? 1 : 0) != 0);
        }
        if ((runner = config.mMergedFlavor.getTestInstrumentationRunner()) != null) {
            return runner;
        }
        if (this.isMultiDexEnabled() && this.isLegacyMultiDexMode()) {
            return MULTIDEX_TEST_RUNNER;
        }
        return DEFAULT_TEST_RUNNER;
    }

    public Map<String, String> getInstrumentationRunnerArguments() {
        VariantConfiguration config = this;
        if (this.mType.isForTesting()) {
            config = this.getTestedConfig();
            Preconditions.checkState((config != null ? 1 : 0) != 0);
        }
        return config.mMergedFlavor.getTestInstrumentationRunnerArguments();
    }

    public Boolean getHandleProfiling() {
        Boolean handleProfiling;
        VariantConfiguration config = this;
        if (this.mType.isForTesting()) {
            config = this.getTestedConfig();
            Preconditions.checkState((config != null ? 1 : 0) != 0);
        }
        return (handleProfiling = config.mMergedFlavor.getTestHandleProfiling()) != null ? handleProfiling : DEFAULT_HANDLE_PROFILING;
    }

    public Boolean getFunctionalTest() {
        Boolean functionalTest;
        VariantConfiguration config = this;
        if (this.mType.isForTesting()) {
            config = this.getTestedConfig();
            Preconditions.checkState((config != null ? 1 : 0) != 0);
        }
        return (functionalTest = config.mMergedFlavor.getTestFunctionalTest()) != null ? functionalTest : DEFAULT_FUNCTIONAL_TEST;
    }

    public String getPackageFromManifest() {
        Preconditions.checkState((!this.mType.isForTesting() ? 1 : 0) != 0);
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        String packageName = this.sManifestParser.getPackage(manifestLocation);
        if (packageName == null) {
            throw new RuntimeException(String.format("Cannot read packageName from %1$s", this.mDefaultSourceProvider.getManifestFile().getAbsolutePath()));
        }
        return packageName;
    }

    public String getVersionNameFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return this.sManifestParser.getVersionName(manifestLocation);
    }

    public int getVersionCodeFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return this.sManifestParser.getVersionCode(manifestLocation);
    }

    public ApiVersion getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        ApiVersion minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == null) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            minSdkVersion = DefaultApiVersion.create(this.sManifestParser.getMinSdkVersion(manifestLocation));
        }
        return minSdkVersion;
    }

    public ApiVersion getTargetSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getTargetSdkVersion();
        }
        ApiVersion targetSdkVersion = this.mMergedFlavor.getTargetSdkVersion();
        if (targetSdkVersion == null) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            targetSdkVersion = DefaultApiVersion.create(this.sManifestParser.getTargetSdkVersion(manifestLocation));
        }
        return targetSdkVersion;
    }

    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    public List<SourceProvider> getSortedSourceProviders() {
        ArrayList providers = Lists.newArrayList();
        providers.add(this.mDefaultSourceProvider);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            providers.add(this.mFlavorSourceProviders.get(n));
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        if (this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        return providers;
    }

    public List<File> getManifestOverlays() {
        File typeLocation;
        File variantLocation;
        ArrayList inputs = Lists.newArrayList();
        if (this.mVariantSourceProvider != null && (variantLocation = this.mVariantSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()).isFile()) {
            inputs.add(typeLocation);
        }
        if (this.mMultiFlavorSourceProvider != null && (variantLocation = this.mMultiFlavorSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (!f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    public List<ResourceSet> getResourceSets(List<File> generatedResFolders, boolean includeDependencies, boolean validateEnabled) {
        ArrayList resourceSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                File resFolder;
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                if (dependency.isOptional() || !(resFolder = dependency.getResFolder()).isDirectory()) continue;
                ResourceSet resourceSet = new ResourceSet(dependency.getFolder().getName(), validateEnabled);
                resourceSet.addSource(resFolder);
                resourceSets.add(resourceSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getResDirectories();
        ResourceSet resourceSet = new ResourceSet("main", validateEnabled);
        resourceSet.addSources(mainResDirs);
        if (!generatedResFolders.isEmpty()) {
            for (File generatedResFolder : generatedResFolders) {
                resourceSet.addSource(generatedResFolder);
            }
        }
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getResDirectories();
            resourceSet = new ResourceSet(sourceProvider.getName(), validateEnabled);
            resourceSet.addSources(flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFlavorName(), validateEnabled);
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName(), validateEnabled);
            resourceSet.addSources(typeResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFullName(), validateEnabled);
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    public List<AssetSet> getAssetSets(List<File> generatedResFolders, boolean includeDependencies) {
        ArrayList assetSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                File assetFolder = dependency.getAssetsFolder();
                if (!assetFolder.isDirectory()) continue;
                AssetSet assetSet = new AssetSet(dependency.getFolder().getName());
                assetSet.addSource(assetFolder);
                assetSets.add(assetSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getAssetsDirectories();
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources(mainResDirs);
        if (!generatedResFolders.isEmpty()) {
            for (File generatedResFolder : generatedResFolders) {
                assetSet.addSource(generatedResFolder);
            }
        }
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(((ProductFlavor)this.mFlavors.get(n)).getName());
            assetSet.addSources(flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFlavorName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources(typeResDirs);
            assetSets.add(assetSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFullName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    public List<AssetSet> getJniLibsSets() {
        ArrayList jniSets = Lists.newArrayList();
        Collection mainJniLibsDirs = this.mDefaultSourceProvider.getJniLibsDirectories();
        AssetSet jniSet = new AssetSet("main");
        jniSet.addSources(mainJniLibsDirs);
        jniSets.add(jniSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorJniDirs = sourceProvider.getJniLibsDirectories();
            jniSet = new AssetSet(((ProductFlavor)this.mFlavors.get(n)).getName());
            jniSet.addSources(flavorJniDirs);
            jniSets.add(jniSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantJniDirs = this.mMultiFlavorSourceProvider.getJniLibsDirectories();
            jniSet = new AssetSet(this.getFlavorName());
            jniSet.addSources(variantJniDirs);
            jniSets.add(jniSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeJniDirs = this.mBuildTypeSourceProvider.getJniLibsDirectories();
            jniSet = new AssetSet(this.mBuildType.getName());
            jniSet.addSources(typeJniDirs);
            jniSets.add(jniSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantJniDirs = this.mVariantSourceProvider.getJniLibsDirectories();
            jniSet = new AssetSet(this.getFullName());
            jniSet.addSources(variantJniDirs);
            jniSets.add(jniSet);
        }
        return jniSets;
    }

    public List<File> getRenderscriptImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File rsLib = lib.getRenderscriptFolder();
            if (!rsLib.isDirectory()) continue;
            list.add(rsLib);
        }
        return list;
    }

    public List<File> getRenderscriptSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getRenderscriptDirectories());
        }
        return sourceList;
    }

    public List<File> getAidlImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File aidlLib = lib.getAidlFolder();
            if (!aidlLib.isDirectory()) continue;
            list.add(aidlLib);
        }
        return list;
    }

    public List<File> getAidlSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getAidlDirectories());
        }
        return sourceList;
    }

    public List<File> getJniSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getCDirectories());
        }
        return sourceList;
    }

    public Set<File> getCompileClasspath() {
        HashSet classpath = Sets.newHashSetWithExpectedSize((int)(this.mExternalJars.size() + this.mLocalJars.size() + this.mFlatLibraries.size()));
        for (LibraryDependency lib : this.mFlatLibraries) {
            classpath.add(lib.getJarFile());
            for (File jarFile : lib.getLocalJars()) {
                classpath.add(jarFile);
            }
        }
        for (JarDependency jar : this.mExternalJars) {
            if (!jar.isCompiled()) continue;
            classpath.add(jar.getJarFile());
        }
        for (JarDependency jar : this.mLocalJars) {
            if (!jar.isCompiled()) continue;
            classpath.add(jar.getJarFile());
        }
        return classpath;
    }

    public Set<File> getAllPackagedJars() {
        HashSet jars = Sets.newHashSetWithExpectedSize((int)(this.mExternalJars.size() + this.mLocalJars.size() + this.mFlatLibraries.size()));
        for (JarDependency jar : this.mExternalJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        jars.addAll(this.getLocalPackagedJars());
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            if (libraryDependency.isOptional()) continue;
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add(libJar);
            }
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add(jarFile);
            }
        }
        return jars;
    }

    public ImmutableSet<File> getExternalPackagedJars() {
        ImmutableSet.Builder jars = ImmutableSet.builder();
        for (JarDependency jar : this.mExternalJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add((Object)jarFile);
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            if (libraryDependency.isOptional() || libraryDependency.getProject() != null) continue;
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add((Object)libJar);
            }
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add((Object)jarFile);
            }
        }
        return jars.build();
    }

    public ImmutableSet<File> getExternalPackagedJarsWithoutAars() {
        ImmutableSet.Builder jars = ImmutableSet.builder();
        for (JarDependency jar : this.mExternalJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add((Object)jarFile);
        }
        return jars.build();
    }

    public ImmutableSet<File> getLocalPackagedJars() {
        ImmutableSet.Builder jars = ImmutableSet.builder();
        ImmutableSet<File> testedlocalJars = null;
        if (this.mTestedConfig != null && this.mTestedConfig.getType() == VariantType.LIBRARY) {
            testedlocalJars = this.mTestedConfig.getLocalPackagedJars();
        }
        for (JarDependency jar : this.mLocalJars) {
            File jarFile = jar.getJarFile();
            if (testedlocalJars != null && testedlocalJars.contains(jarFile) || !jar.isPackaged() || !jarFile.exists()) continue;
            jars.add((Object)jarFile);
        }
        return jars.build();
    }

    public ImmutableSet<File> getSubProjectPackagedJars() {
        ImmutableSet.Builder jars = ImmutableSet.builder();
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File libJar;
            if (libraryDependency.isOptional() || libraryDependency.getProject() == null || !(libJar = libraryDependency.getJarFile()).exists()) continue;
            jars.add((Object)libJar);
        }
        return jars.build();
    }

    public ImmutableSet<File> getSubProjectLocalPackagedJars() {
        ImmutableSet.Builder jars = ImmutableSet.builder();
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            if (libraryDependency.isOptional() || libraryDependency.getProject() == null) continue;
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add((Object)jarFile);
            }
        }
        return jars.build();
    }

    public ImmutableSet<File> getSubProjectJniLibraries() {
        ImmutableSet.Builder jniDirectories = ImmutableSet.builder();
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File jniDir;
            if (libraryDependency.isOptional() || libraryDependency.getProject() == null || !(jniDir = libraryDependency.getJniFolder()).exists()) continue;
            jniDirectories.add((Object)jniDir);
        }
        return jniDirectories.build();
    }

    public ImmutableSet<File> getExternalAarJniLibraries() {
        ImmutableSet.Builder jniDirectories = ImmutableSet.builder();
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File jniDir;
            if (libraryDependency.isOptional() || libraryDependency.getProject() != null || !(jniDir = libraryDependency.getJniFolder()).exists()) continue;
            jniDirectories.add((Object)jniDir);
        }
        return jniDirectories.build();
    }

    public List<File> getProvidedOnlyJars() {
        File jarFile;
        HashSet jars = Sets.newHashSetWithExpectedSize((int)(this.mExternalJars.size() + this.mLocalJars.size() + this.mFlatLibraries.size()));
        for (JarDependency jar : this.mExternalJars) {
            jarFile = jar.getJarFile();
            if (!jar.isCompiled() || jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (JarDependency jar : this.mLocalJars) {
            jarFile = jar.getJarFile();
            if (!jar.isCompiled() || jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            if (!libraryDependency.isOptional()) continue;
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add(libJar);
            }
            for (File jarFile2 : libraryDependency.getLocalJars()) {
                if (!jarFile2.isFile()) continue;
                jars.add(jarFile2);
            }
        }
        return Lists.newArrayList((Iterable)jars);
    }

    public String resolveLibraryName(File jarFile) {
        for (JarDependency jar : this.mExternalJars) {
            if (!jarFile.equals(jar.getJarFile())) continue;
            if (jar.getResolvedCoordinates() != null) {
                return jar.getResolvedCoordinates().toString();
            }
            return "unresolved-ext-jar-" + jarFile.getName() + "-" + jarFile.getPath().hashCode();
        }
        for (JarDependency jar : this.mLocalJars) {
            if (!jarFile.equals(jar.getJarFile())) continue;
            return "local-jar-" + jarFile.getName() + "-" + jarFile.getPath().hashCode();
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            if (jarFile.equals(libraryDependency.getJarFile())) {
                if (libraryDependency.getResolvedCoordinates() != null) {
                    return libraryDependency.getResolvedCoordinates().toString();
                }
                return "unresolved-lib-" + jarFile.getName() + "-" + jarFile.getPath().hashCode();
            }
            for (File localjar : libraryDependency.getLocalJars()) {
                if (!jarFile.equals(localjar) || libraryDependency.getResolvedCoordinates() == null) continue;
                return libraryDependency.getResolvedCoordinates().toString() + ":" + jarFile.getName();
            }
        }
        return null;
    }

    public void addBuildConfigField(String type, String name, String value) {
        ClassField classField = AndroidBuilder.createClassField(type, name, value);
        this.mBuildConfigFields.put(name, classField);
    }

    public void addResValue(String type, String name, String value) {
        ClassField classField = AndroidBuilder.createClassField(type, name, value);
        this.mResValues.put(name, classField);
    }

    public List<Object> getBuildConfigItems() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mBuildConfigFields.values();
        if (!list.isEmpty()) {
            fullList.add("Fields from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getBuildConfigFields().values()).isEmpty()) {
            fullList.add("Fields from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getBuildConfigFields().values();
            if (list.isEmpty()) continue;
            fullList.add("Fields from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getBuildConfigFields().values();
        if (!list.isEmpty()) {
            fullList.add("Fields from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    public Map<String, ClassField> getMergedBuildConfigFields() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getBuildConfigFields());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getBuildConfigFields());
        }
        mergedMap.putAll(this.mBuildType.getBuildConfigFields());
        mergedMap.putAll(this.mBuildConfigFields);
        return mergedMap;
    }

    public Map<String, ClassField> getMergedResValues() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getResValues());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getResValues());
        }
        mergedMap.putAll(this.mBuildType.getResValues());
        mergedMap.putAll(this.mResValues);
        return mergedMap;
    }

    private static void fillFieldList(List<Object> outList, Set<String> usedFieldNames, Collection<ClassField> list) {
        for (ClassField f : list) {
            String name = f.getName();
            if (usedFieldNames.contains(name)) continue;
            usedFieldNames.add(f.getName());
            outList.add(f);
        }
    }

    public List<Object> getResValues() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mResValues.values();
        if (!list.isEmpty()) {
            fullList.add("Values from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getResValues().values()).isEmpty()) {
            fullList.add("Values from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getResValues().values();
            if (list.isEmpty()) continue;
            fullList.add("Values from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getResValues().values();
        if (!list.isEmpty()) {
            fullList.add("Values from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    public SigningConfig getSigningConfig() {
        if (this.mSigningConfigOverride != null) {
            return this.mSigningConfigOverride;
        }
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    public Set<File> getProguardFiles(boolean includeLibraries, List<File> defaultProguardConfig) {
        HashSet fullList = Sets.newHashSet();
        fullList.addAll(this.mDefaultConfig.getProguardFiles());
        fullList.addAll(this.mBuildType.getProguardFiles());
        for (ProductFlavor flavor : this.mFlavors) {
            fullList.addAll(flavor.getProguardFiles());
        }
        if (fullList.isEmpty()) {
            fullList.addAll(defaultProguardConfig);
        }
        if (includeLibraries) {
            for (LibraryDependency libraryDependency : this.mFlatLibraries) {
                File proguardRules = libraryDependency.getProguardRules();
                if (!proguardRules.exists()) continue;
                fullList.add(proguardRules);
            }
        }
        return fullList;
    }

    public Set<File> getTestProguardFiles() {
        HashSet fullList = Sets.newHashSet();
        fullList.addAll(this.mDefaultConfig.getTestProguardFiles());
        fullList.addAll(this.mBuildType.getTestProguardFiles());
        for (ProductFlavor flavor : this.mFlavors) {
            fullList.addAll(flavor.getTestProguardFiles());
        }
        return fullList;
    }

    public List<Object> getConsumerProguardFiles() {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getConsumerProguardFiles());
        fullList.addAll(this.mBuildType.getConsumerProguardFiles());
        for (ProductFlavor flavor : this.mFlavors) {
            fullList.addAll(flavor.getConsumerProguardFiles());
        }
        return fullList;
    }

    public boolean isTestCoverageEnabled() {
        return this.mBuildType.isTestCoverageEnabled();
    }

    public Map<String, Object> getManifestPlaceholders() {
        Map mergedFlavorsPlaceholders = this.mMergedFlavor.getManifestPlaceholders();
        mergedFlavorsPlaceholders.putAll(this.mBuildType.getManifestPlaceholders());
        return mergedFlavorsPlaceholders;
    }

    public boolean isMultiDexEnabled() {
        Boolean value = this.mBuildType.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public File getMultiDexKeepFile() {
        File value = this.mBuildType.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        return null;
    }

    public File getMultiDexKeepProguard() {
        File value = this.mBuildType.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        return null;
    }

    public boolean isLegacyMultiDexMode() {
        return this.isMultiDexEnabled() && this.getMinSdkVersion().getApiLevel() < 21;
    }

    public boolean getRenderscriptSupportModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptSupportModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean getRenderscriptNdkModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptNdkModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public Collection<File> getJarJarRuleFiles() {
        ImmutableList.Builder jarjarRuleFiles = ImmutableList.builder();
        jarjarRuleFiles.addAll((Iterable)this.getMergedFlavor().getJarJarRuleFiles());
        jarjarRuleFiles.addAll((Iterable)this.mBuildType.getJarJarRuleFiles());
        return jarjarRuleFiles.build();
    }
}

