/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.NamedNodeMap;

public class JackConversionCache
extends PreProcessCache<PreProcessCache.Key> {
    private static final JackConversionCache sSingleton = new JackConversionCache();

    public static JackConversionCache getCache() {
        return sSingleton;
    }

    @Override
    @NonNull
    protected PreProcessCache.KeyFactory<PreProcessCache.Key> getKeyFactory() {
        return new PreProcessCache.KeyFactory<PreProcessCache.Key>(){

            @Override
            public PreProcessCache.Key of(@NonNull File sourceFile, @NonNull FullRevision revision, @NonNull NamedNodeMap attrMap) {
                return PreProcessCache.Key.of(sourceFile, revision);
            }
        };
    }

    public void convertLibrary(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull JavaProcessExecutor processExecutor, @NonNull ProcessOutputHandler processOutputHandler, @NonNull ILogger logger) throws ProcessException, InterruptedException, IOException {
        PreProcessCache.Key itemKey = PreProcessCache.Key.of(inputFile, buildToolInfo.getRevision());
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                List<File> files = AndroidBuilder.convertLibaryToJackUsingApis(inputFile, outFile, dexOptions, buildToolInfo, verbose, processExecutor, processOutputHandler, logger);
                item.getOutputFiles().addAll(files);
                this.incrementMisses();
            }
            catch (ProcessException exception) {
                outFile.delete();
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else {
            item.getLatch().await();
            File fromFile = item.getOutputFiles().get(0);
            if (fromFile.isFile()) {
                Files.copy((File)fromFile, (File)outFile);
                this.incrementHits();
            }
        }
    }
}

