/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class BaseConfigImpl
implements Serializable,
BaseConfig {
    private static final long serialVersionUID = 1L;
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final List<File> mProguardFiles = Lists.newArrayList();
    private final List<File> mConsumerProguardFiles = Lists.newArrayList();
    private final List<File> mTestProguardFiles = Lists.newArrayList();
    private final Map<String, Object> mManifestPlaceholders = Maps.newHashMap();
    @Nullable
    private Boolean mMultiDexEnabled;
    @Nullable
    private File mMultiDexKeepProguard;
    @Nullable
    private File mMultiDexKeepFile;

    public void addBuildConfigField(@NonNull ClassField field) {
        this.mBuildConfigFields.put(field.getName(), field);
    }

    public void addResValue(@NonNull ClassField field) {
        this.mResValues.put(field.getName(), field);
    }

    public void addResValues(@NonNull Map<String, ClassField> values) {
        this.mResValues.putAll(values);
    }

    @NonNull
    public Map<String, ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    public void addBuildConfigFields(@NonNull Map<String, ClassField> fields) {
        this.mBuildConfigFields.putAll(fields);
    }

    @NonNull
    public Map<String, ClassField> getResValues() {
        return this.mResValues;
    }

    @NonNull
    public List<File> getProguardFiles() {
        return this.mProguardFiles;
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return this.mConsumerProguardFiles;
    }

    @NonNull
    public List<File> getTestProguardFiles() {
        return this.mTestProguardFiles;
    }

    @NonNull
    public Map<String, Object> getManifestPlaceholders() {
        return this.mManifestPlaceholders;
    }

    public void addManifestPlaceholders(@NonNull Map<String, Object> manifestPlaceholders) {
        this.mManifestPlaceholders.putAll(manifestPlaceholders);
    }

    public void setManifestPlaceholders(@NonNull Map<String, Object> manifestPlaceholders) {
        this.mManifestPlaceholders.clear();
        this.mManifestPlaceholders.putAll(manifestPlaceholders);
    }

    protected void _initWith(@NonNull BaseConfig that) {
        this.setBuildConfigFields(that.getBuildConfigFields());
        this.setResValues(that.getResValues());
        this.mProguardFiles.clear();
        this.mProguardFiles.addAll(that.getProguardFiles());
        this.mConsumerProguardFiles.clear();
        this.mConsumerProguardFiles.addAll(that.getConsumerProguardFiles());
        this.mTestProguardFiles.clear();
        this.mTestProguardFiles.addAll(that.getTestProguardFiles());
        this.mManifestPlaceholders.clear();
        this.mManifestPlaceholders.putAll(that.getManifestPlaceholders());
        this.mMultiDexEnabled = that.getMultiDexEnabled();
        this.mMultiDexKeepFile = that.getMultiDexKeepFile();
        this.mMultiDexKeepProguard = that.getMultiDexKeepProguard();
    }

    private void setBuildConfigFields(@NonNull Map<String, ClassField> fields) {
        this.mBuildConfigFields.clear();
        this.mBuildConfigFields.putAll(fields);
    }

    private void setResValues(@NonNull Map<String, ClassField> fields) {
        this.mResValues.clear();
        this.mResValues.putAll(fields);
    }

    @Nullable
    public Boolean getMultiDexEnabled() {
        return this.mMultiDexEnabled;
    }

    public void setMultiDexEnabled(@Nullable Boolean multiDex) {
        this.mMultiDexEnabled = multiDex;
    }

    @Nullable
    public File getMultiDexKeepFile() {
        return this.mMultiDexKeepFile;
    }

    public void setMultiDexKeepFile(@Nullable File file) {
        this.mMultiDexKeepFile = file;
    }

    @Nullable
    public File getMultiDexKeepProguard() {
        return this.mMultiDexKeepProguard;
    }

    public void setMultiDexKeepProguard(@Nullable File file) {
        this.mMultiDexKeepProguard = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseConfigImpl)) {
            return false;
        }
        BaseConfigImpl that = (BaseConfigImpl)o;
        if (!((Object)this.mBuildConfigFields).equals(that.mBuildConfigFields)) {
            return false;
        }
        if (!((Object)this.mConsumerProguardFiles).equals(that.mConsumerProguardFiles)) {
            return false;
        }
        if (!((Object)this.mManifestPlaceholders).equals(that.mManifestPlaceholders)) {
            return false;
        }
        if (this.mMultiDexEnabled != null ? !this.mMultiDexEnabled.equals(that.mMultiDexEnabled) : that.mMultiDexEnabled != null) {
            return false;
        }
        if (this.mMultiDexKeepFile != null ? !this.mMultiDexKeepFile.equals(that.mMultiDexKeepFile) : that.mMultiDexKeepFile != null) {
            return false;
        }
        if (this.mMultiDexKeepProguard != null ? !this.mMultiDexKeepProguard.equals(that.mMultiDexKeepProguard) : that.mMultiDexKeepProguard != null) {
            return false;
        }
        if (!((Object)this.mProguardFiles).equals(that.mProguardFiles)) {
            return false;
        }
        return ((Object)this.mResValues).equals(that.mResValues);
    }

    public int hashCode() {
        int result = ((Object)this.mBuildConfigFields).hashCode();
        result = 31 * result + ((Object)this.mResValues).hashCode();
        result = 31 * result + ((Object)this.mProguardFiles).hashCode();
        result = 31 * result + ((Object)this.mConsumerProguardFiles).hashCode();
        result = 31 * result + ((Object)this.mManifestPlaceholders).hashCode();
        result = 31 * result + (this.mMultiDexEnabled != null ? this.mMultiDexEnabled.hashCode() : 0);
        result = 31 * result + (this.mMultiDexKeepFile != null ? this.mMultiDexKeepFile.hashCode() : 0);
        result = 31 * result + (this.mMultiDexKeepProguard != null ? this.mMultiDexKeepProguard.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BaseConfigImpl{mBuildConfigFields=" + this.mBuildConfigFields + ", mResValues=" + this.mResValues + ", mProguardFiles=" + this.mProguardFiles + ", mConsumerProguardFiles=" + this.mConsumerProguardFiles + ", mManifestPlaceholders=" + this.mManifestPlaceholders + ", mMultiDexEnabled=" + this.mMultiDexEnabled + ", mMultiDexKeepFile=" + this.mMultiDexKeepFile + ", mMultiDexKeepProguard=" + this.mMultiDexKeepProguard + '}';
    }
}

