/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.compiling;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AndroidBuilder;
import com.android.builder.model.ClassField;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.squareup.javawriter.JavaWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;

public class BuildConfigGenerator {
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";
    private final File mGenFolder;
    private final String mBuildConfigPackageName;
    private final List<ClassField> mFields = Lists.newArrayList();
    private List<Object> mItems = Lists.newArrayList();

    public BuildConfigGenerator(@NonNull File genFolder, @NonNull String buildConfigPackageName) {
        this.mGenFolder = (File)Preconditions.checkNotNull((Object)genFolder);
        this.mBuildConfigPackageName = (String)Preconditions.checkNotNull((Object)buildConfigPackageName);
    }

    public BuildConfigGenerator addField(@NonNull String type, @NonNull String name, @NonNull String value) {
        this.mFields.add(AndroidBuilder.createClassField(type, name, value));
        return this;
    }

    public BuildConfigGenerator addItems(@Nullable Collection<Object> items) {
        if (items != null) {
            this.mItems.addAll(items);
        }
        return this;
    }

    public File getFolderPath() {
        return new File(this.mGenFolder, this.mBuildConfigPackageName.replace('.', File.separatorChar));
    }

    public File getBuildConfigFile() {
        File folder = this.getFolderPath();
        return new File(folder, BUILD_CONFIG_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        File pkgFolder = this.getFolderPath();
        if (!pkgFolder.isDirectory() && !pkgFolder.mkdirs()) {
            throw new RuntimeException("Failed to create " + pkgFolder.getAbsolutePath());
        }
        File buildConfigJava = new File(pkgFolder, BUILD_CONFIG_NAME);
        FileWriter out = new FileWriter(buildConfigJava);
        JavaWriter writer = new JavaWriter((Writer)out);
        try {
            EnumSet<Modifier> publicFinal = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
            EnumSet<Modifier> publicFinalStatic = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC);
            writer.emitJavadoc("Automatically generated file. DO NOT MODIFY", new Object[0]).emitPackage(this.mBuildConfigPackageName).beginType("BuildConfig", "class", publicFinal);
            for (ClassField field : this.mFields) {
                writer.emitField(field.getType(), field.getName(), publicFinalStatic, field.getValue());
            }
            for (Object item : this.mItems) {
                if (item instanceof ClassField) {
                    ClassField field = (ClassField)item;
                    writer.emitField(field.getType(), field.getName(), publicFinalStatic, field.getValue());
                    continue;
                }
                if (!(item instanceof String)) continue;
                writer.emitSingleLineComment((String)item, new Object[0]);
            }
            writer.endType();
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
            Closeables.closeQuietly((Closeable)out);
        }
    }
}

