/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.NdkConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class DefaultProductFlavor
extends BaseConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private int mMinSdkVersion = -1;
    private int mTargetSdkVersion = -1;
    private int mRenderscriptTargetApi = -1;
    private Boolean mRenderscriptSupportMode;
    private Boolean mRenderscriptNdkMode;
    private int mVersionCode = -1;
    private String mVersionName = null;
    private String mPackageName = null;
    private String mTestPackageName = null;
    private String mTestInstrumentationRunner = null;
    private Boolean mTestHandleProfiling = null;
    private Boolean mTestFunctionalTest = null;
    private SigningConfig mSigningConfig = null;
    private Set<String> mResourceConfiguration = null;

    public DefaultProductFlavor(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public ProductFlavor setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public ProductFlavor setVersionCode(int versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @NonNull
    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @NonNull
    public ProductFlavor setMinSdkVersion(int minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @NonNull
    public ProductFlavor setTargetSdkVersion(int targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public int getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(int renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    public boolean getRenderscriptSupportMode() {
        return this.mRenderscriptSupportMode != null && this.mRenderscriptSupportMode != false;
    }

    public void setRenderscriptSupportMode(boolean renderscriptSupportMode) {
        this.mRenderscriptSupportMode = renderscriptSupportMode;
    }

    public boolean getRenderscriptNdkMode() {
        return this.mRenderscriptNdkMode != null && this.mRenderscriptNdkMode != false;
    }

    public void setRenderscriptNdkMode(boolean renderscriptNdkMode) {
        this.mRenderscriptNdkMode = renderscriptNdkMode;
    }

    @NonNull
    public ProductFlavor setTestPackageName(String testPackageName) {
        this.mTestPackageName = testPackageName;
        return this;
    }

    @Nullable
    public String getTestPackageName() {
        return this.mTestPackageName;
    }

    @NonNull
    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    @NonNull
    public ProductFlavor setTestHandleProfiling(boolean handleProfiling) {
        this.mTestHandleProfiling = handleProfiling;
        return this;
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    @NonNull
    public ProductFlavor setTestFunctionalTest(boolean functionalTest) {
        this.mTestFunctionalTest = functionalTest;
        return this;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @NonNull
    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    @Nullable
    public NdkConfig getNdkConfig() {
        return null;
    }

    public void addResourceConfiguration(@NonNull String configuration) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.add(configuration);
    }

    public void addResourceConfigurations(String ... configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(Arrays.asList(configurations));
    }

    public void addResourceConfigurations(@NonNull Collection<String> configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(configurations);
    }

    @NonNull
    public Collection<String> getResourceConfigurations() {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        return this.mResourceConfiguration;
    }

    @NonNull
    DefaultProductFlavor mergeOver(@NonNull DefaultProductFlavor base) {
        DefaultProductFlavor flavor = new DefaultProductFlavor("");
        flavor.mMinSdkVersion = this.chooseInt(this.mMinSdkVersion, base.mMinSdkVersion);
        flavor.mTargetSdkVersion = this.chooseInt(this.mTargetSdkVersion, base.mTargetSdkVersion);
        flavor.mRenderscriptTargetApi = this.chooseInt(this.mRenderscriptTargetApi, base.mRenderscriptTargetApi);
        flavor.mRenderscriptSupportMode = this.chooseBoolean(this.mRenderscriptSupportMode, base.mRenderscriptSupportMode);
        flavor.mRenderscriptNdkMode = this.chooseBoolean(this.mRenderscriptNdkMode, base.mRenderscriptNdkMode);
        flavor.mVersionCode = this.chooseInt(this.mVersionCode, base.mVersionCode);
        flavor.mVersionName = this.chooseString(this.mVersionName, base.mVersionName);
        flavor.mPackageName = this.chooseString(this.mPackageName, base.mPackageName);
        flavor.mTestPackageName = this.chooseString(this.mTestPackageName, base.mTestPackageName);
        flavor.mTestInstrumentationRunner = this.chooseString(this.mTestInstrumentationRunner, base.mTestInstrumentationRunner);
        flavor.mTestHandleProfiling = this.chooseBoolean(this.mTestHandleProfiling, base.mTestHandleProfiling);
        flavor.mTestFunctionalTest = this.chooseBoolean(this.mTestFunctionalTest, base.mTestFunctionalTest);
        flavor.mSigningConfig = this.mSigningConfig != null ? this.mSigningConfig : base.mSigningConfig;
        flavor.addResourceConfigurations(this.getResourceConfigurations());
        flavor.addResourceConfigurations(base.getResourceConfigurations());
        return flavor;
    }

    private int chooseInt(int overlay, int base) {
        return overlay != -1 ? overlay : base;
    }

    @Nullable
    private String chooseString(String overlay, String base) {
        return overlay != null ? overlay : base;
    }

    private Boolean chooseBoolean(Boolean overlay, Boolean base) {
        return overlay != null ? overlay : base;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultProductFlavor that = (DefaultProductFlavor)o;
        if (this.mMinSdkVersion != that.mMinSdkVersion) {
            return false;
        }
        if (this.mRenderscriptTargetApi != that.mRenderscriptTargetApi) {
            return false;
        }
        if (this.mTargetSdkVersion != that.mTargetSdkVersion) {
            return false;
        }
        if (this.mVersionCode != that.mVersionCode) {
            return false;
        }
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        if (this.mPackageName != null ? !this.mPackageName.equals(that.mPackageName) : that.mPackageName != null) {
            return false;
        }
        if (this.mRenderscriptNdkMode != null ? !this.mRenderscriptNdkMode.equals(that.mRenderscriptNdkMode) : that.mRenderscriptNdkMode != null) {
            return false;
        }
        if (this.mRenderscriptSupportMode != null ? !this.mRenderscriptSupportMode.equals(that.mRenderscriptSupportMode) : that.mRenderscriptSupportMode != null) {
            return false;
        }
        if (this.mResourceConfiguration != null ? !((Object)this.mResourceConfiguration).equals(that.mResourceConfiguration) : that.mResourceConfiguration != null) {
            return false;
        }
        if (this.mSigningConfig != null ? !this.mSigningConfig.equals(that.mSigningConfig) : that.mSigningConfig != null) {
            return false;
        }
        if (this.mTestFunctionalTest != null ? !this.mTestFunctionalTest.equals(that.mTestFunctionalTest) : that.mTestFunctionalTest != null) {
            return false;
        }
        if (this.mTestHandleProfiling != null ? !this.mTestHandleProfiling.equals(that.mTestHandleProfiling) : that.mTestHandleProfiling != null) {
            return false;
        }
        if (this.mTestInstrumentationRunner != null ? !this.mTestInstrumentationRunner.equals(that.mTestInstrumentationRunner) : that.mTestInstrumentationRunner != null) {
            return false;
        }
        if (this.mTestPackageName != null ? !this.mTestPackageName.equals(that.mTestPackageName) : that.mTestPackageName != null) {
            return false;
        }
        return !(this.mVersionName != null ? !this.mVersionName.equals(that.mVersionName) : that.mVersionName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + this.mMinSdkVersion;
        result = 31 * result + this.mTargetSdkVersion;
        result = 31 * result + this.mRenderscriptTargetApi;
        result = 31 * result + (this.mRenderscriptSupportMode != null ? this.mRenderscriptSupportMode.hashCode() : 0);
        result = 31 * result + (this.mRenderscriptNdkMode != null ? this.mRenderscriptNdkMode.hashCode() : 0);
        result = 31 * result + this.mVersionCode;
        result = 31 * result + (this.mVersionName != null ? this.mVersionName.hashCode() : 0);
        result = 31 * result + (this.mPackageName != null ? this.mPackageName.hashCode() : 0);
        result = 31 * result + (this.mTestPackageName != null ? this.mTestPackageName.hashCode() : 0);
        result = 31 * result + (this.mTestInstrumentationRunner != null ? this.mTestInstrumentationRunner.hashCode() : 0);
        result = 31 * result + (this.mTestHandleProfiling != null ? this.mTestHandleProfiling.hashCode() : 0);
        result = 31 * result + (this.mTestFunctionalTest != null ? this.mTestFunctionalTest.hashCode() : 0);
        result = 31 * result + (this.mSigningConfig != null ? this.mSigningConfig.hashCode() : 0);
        result = 31 * result + (this.mResourceConfiguration != null ? ((Object)this.mResourceConfiguration).hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("minSdkVersion", this.mMinSdkVersion).add("targetSdkVersion", this.mTargetSdkVersion).add("renderscriptTargetApi", this.mRenderscriptTargetApi).add("renderscriptSupportMode", (Object)this.mRenderscriptSupportMode).add("renderscriptNdkMode", (Object)this.mRenderscriptNdkMode).add("versionCode", this.mVersionCode).add("versionName", (Object)this.mVersionName).add("packageName", (Object)this.mPackageName).add("testPackageName", (Object)this.mTestPackageName).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("testHandleProfiling", (Object)this.mTestHandleProfiling).add("testFunctionalTest", (Object)this.mTestFunctionalTest).add("signingConfig", (Object)this.mSigningConfig).add("resConfig", this.mResourceConfiguration).toString();
    }
}

