/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.proxy.internal.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.internal.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.jersey.JerseyAwsProxyRequestReader;
import com.amazonaws.serverless.proxy.jersey.JerseyAwsProxyResponseWriter;
import com.amazonaws.serverless.proxy.jersey.JerseyResponseWriter;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class JerseyLambdaContainerHandler<RequestType, ResponseType>
extends LambdaContainerHandler<RequestType, ResponseType, ContainerRequest, JerseyResponseWriter>
implements Container {
    private Application jaxRsApplication;
    private ApplicationHandler applicationHandler;

    public static JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Application jaxRsApplication) {
        return new JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>(new JerseyAwsProxyRequestReader(), new JerseyAwsProxyResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), jaxRsApplication);
    }

    public JerseyLambdaContainerHandler(RequestReader<RequestType, ContainerRequest> requestReader, ResponseWriter<JerseyResponseWriter, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, Application jaxRsApplication) {
        super(requestReader, responseWriter, securityContextWriter, exceptionHandler);
        this.jaxRsApplication = jaxRsApplication;
        this.applicationHandler = new ApplicationHandler(jaxRsApplication);
        this.applicationHandler.onStartup((Container)this);
    }

    public ResourceConfig getConfiguration() {
        return this.applicationHandler.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.applicationHandler;
    }

    public void reload() {
        this.applicationHandler.onShutdown((Container)this);
        this.applicationHandler = new ApplicationHandler(this.jaxRsApplication);
        this.applicationHandler.onReload((Container)this);
        this.applicationHandler.onStartup((Container)this);
    }

    public void reload(ResourceConfig resourceConfig) {
        this.applicationHandler.onShutdown((Container)this);
        this.jaxRsApplication = resourceConfig;
        this.applicationHandler = new ApplicationHandler((Application)resourceConfig);
        this.applicationHandler.onReload((Container)this);
        this.applicationHandler.onStartup((Container)this);
    }

    protected JerseyResponseWriter getContainerResponse(CountDownLatch latch) {
        return new JerseyResponseWriter(latch);
    }

    protected void handleRequest(ContainerRequest containerRequest, JerseyResponseWriter jerseyResponseWriter, Context lambdaContext) {
        containerRequest.setWriter((ContainerResponseWriter)jerseyResponseWriter);
        this.applicationHandler.handle(containerRequest);
    }
}

