/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.jersey.JerseyResponseWriter;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.Base64;

public class JerseyAwsProxyResponseWriter
extends ResponseWriter<JerseyResponseWriter, AwsProxyResponse> {
    public AwsProxyResponse writeResponse(JerseyResponseWriter containerResponse, Context lambdaContext) throws InvalidResponseObjectException {
        try {
            AwsProxyResponse response = new AwsProxyResponse();
            response.setStatusCode(containerResponse.getStatusCode());
            if (containerResponse.getHeaders() != null && containerResponse.getHeaders().size() > 0) {
                response.setHeaders(containerResponse.getHeaders());
            }
            if (containerResponse.getResponseBody() != null) {
                String responseString;
                if (this.isValidUtf8(containerResponse.getResponseBody().toByteArray())) {
                    responseString = new String(containerResponse.getResponseBody().toByteArray());
                } else {
                    responseString = Base64.getMimeEncoder().encodeToString(containerResponse.getResponseBody().toByteArray());
                    response.setBase64Encoded(true);
                }
                response.setBody(responseString);
            }
            return response;
        }
        catch (Exception ex) {
            throw new InvalidResponseObjectException(ex.getMessage(), ex);
        }
    }
}

