/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import com.amazonaws.secretsmanager.util.SQLExceptionUtils;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.util.StringUtils;

public final class AWSSecretsManagerMariaDBDriver
extends AWSSecretsManagerDriver {
    public static final int ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = 1045;
    public static final String SUBPREFIX = "mariadb";

    public AWSSecretsManagerMariaDBDriver() {
    }

    public AWSSecretsManagerMariaDBDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerMariaDBDriver(AWSSecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerMariaDBDriver(AWSSecretsManager client) {
        super(client);
    }

    public AWSSecretsManagerMariaDBDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        return SQLExceptionUtils.unwrapAndCheckForCode(e, 1045);
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:mariadb://" + endpoint;
        if (!StringUtils.isNullOrEmpty((String)port)) {
            url = url + ":" + port;
        }
        if (!StringUtils.isNullOrEmpty((String)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "org.mariadb.jdbc.Driver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerMariaDBDriver());
    }
}

