/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.util;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.secretsmanager.util.Config;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.util.StringUtils;

public class JDBCSecretCacheBuilderProvider {
    static final String PROPERTY_VPC_ENDPOINT_URL = "vpcEndpointUrl";
    static final String PROPERTY_VPC_ENDPOINT_REGION = "vpcEndpointRegion";
    static final String PROPERTY_REGION = "region";
    static final String REGION_ENVIRONMENT_VARIABLE = "AWS_SECRET_JDBC_REGION";
    private Config configFile;

    public JDBCSecretCacheBuilderProvider() {
        this(Config.loadMainConfig());
    }

    public JDBCSecretCacheBuilderProvider(Config config) {
        this.configFile = config;
    }

    public AWSSecretsManagerClientBuilder build() {
        AWSSecretsManagerClientBuilder builder = AWSSecretsManagerClientBuilder.standard();
        String vpcEndpointUrl = this.configFile.getStringPropertyWithDefault("drivers.vpcEndpointUrl", null);
        String vpcEndpointRegion = this.configFile.getStringPropertyWithDefault("drivers.vpcEndpointRegion", null);
        String envRegion = System.getenv(REGION_ENVIRONMENT_VARIABLE);
        String configRegion = this.configFile.getStringPropertyWithDefault("drivers.region", null);
        if (!StringUtils.isNullOrEmpty((String)vpcEndpointUrl) && !StringUtils.isNullOrEmpty((String)vpcEndpointRegion)) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(vpcEndpointUrl, vpcEndpointRegion));
        } else if (!StringUtils.isNullOrEmpty((String)envRegion)) {
            builder.withRegion(envRegion);
        } else if (!StringUtils.isNullOrEmpty((String)configRegion)) {
            builder.withRegion(configRegion);
        }
        return builder;
    }
}

