/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.util.StringUtils;
import java.sql.SQLException;

public final class AWSSecretsManagerMySQLDriver
extends AWSSecretsManagerDriver {
    public static final int ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = 1045;
    public static final String SUBPREFIX = "mysql";

    public AWSSecretsManagerMySQLDriver() {
    }

    public AWSSecretsManagerMySQLDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerMySQLDriver(AWSSecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerMySQLDriver(AWSSecretsManager client) {
        super(client);
    }

    public AWSSecretsManagerMySQLDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            int errorCode = sqle.getErrorCode();
            return errorCode == 1045;
        }
        return false;
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:mysql://" + endpoint;
        if (!StringUtils.isNullOrEmpty((String)port)) {
            url = url + ":" + port;
        }
        if (!StringUtils.isNullOrEmpty((String)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "com.mysql.jdbc.Driver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerMySQLDriver());
    }
}

