/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private final LRULinkedHashMap<K, V> map;
    private static final int DEFAULT_MAX_SIZE = 1024;

    public LRUCache() {
        this(1024);
    }

    public LRUCache(int maxSize) {
        this.map = new LRULinkedHashMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, V value) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<? extends K, ? extends V> map2 = map;
        synchronized (map2) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.putIfAbsent(key, value) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.remove(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V oldValue) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.remove(key, oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRULinkedHashMap<K, V> lRULinkedHashMap = this.map;
        synchronized (lRULinkedHashMap) {
            this.map.clear();
        }
    }

    private static class LRULinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 16L;
        private final int maxSize;

        LRULinkedHashMap(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

