/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching;

import com.amazonaws.secretsmanager.caching.SecretCacheHook;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public class SecretCacheConfiguration {
    public static final int DEFAULT_MAX_CACHE_SIZE = 1024;
    public static final long DEFAULT_CACHE_ITEM_TTL = TimeUnit.HOURS.toMillis(1L);
    public static final String DEFAULT_VERSION_STAGE = "AWSCURRENT";
    public static final long DEFAULT_FORCE_REFRESH_JITTER = 100L;
    private SecretsManagerClient client = null;
    private SecretCacheHook cacheHook = null;
    private int maxCacheSize = 1024;
    private long cacheItemTTL = DEFAULT_CACHE_ITEM_TTL;
    private String versionStage = "AWSCURRENT";
    private long forceRefreshJitterMillis = 100L;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SecretsManagerClient getClient() {
        return this.client;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setClient(SecretsManagerClient client) {
        this.client = client;
    }

    public SecretCacheConfiguration withClient(SecretsManagerClient client) {
        this.setClient(client);
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SecretCacheHook getCacheHook() {
        return this.cacheHook;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setCacheHook(SecretCacheHook cacheHook) {
        this.cacheHook = cacheHook;
    }

    public SecretCacheConfiguration withCacheHook(SecretCacheHook cacheHook) {
        this.setCacheHook(cacheHook);
        return this;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public SecretCacheConfiguration withMaxCacheSize(int maxCacheSize) {
        this.setMaxCacheSize(maxCacheSize);
        return this;
    }

    public long getCacheItemTTL() {
        return this.cacheItemTTL;
    }

    public void setCacheItemTTL(long cacheItemTTL) {
        this.cacheItemTTL = cacheItemTTL;
    }

    public SecretCacheConfiguration withCacheItemTTL(long cacheItemTTL) {
        this.setCacheItemTTL(cacheItemTTL);
        return this;
    }

    public String getVersionStage() {
        return this.versionStage;
    }

    public void setVersionStage(String versionStage) {
        this.versionStage = versionStage;
    }

    public SecretCacheConfiguration withVersionStage(String versionStage) {
        this.setVersionStage(versionStage);
        return this;
    }

    public long getForceRefreshJitterMillis() {
        return this.forceRefreshJitterMillis;
    }

    public void setForceRefreshJitterMillis(long forceRefreshJitterMillis) {
        if (forceRefreshJitterMillis < 0L) {
            throw new IllegalArgumentException("Force refresh jitter must be greater than or equal to zero");
        }
        this.forceRefreshJitterMillis = forceRefreshJitterMillis;
    }

    public SecretCacheConfiguration withForceRefreshJitterMillis(long forceRefreshJitterMillis) {
        this.setForceRefreshJitterMillis(forceRefreshJitterMillis);
        return this;
    }
}

