/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.ops.BaseOperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.ConfigurationType;
import net.spy.memcached.ops.DeleteConfigOperation;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetConfigOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.MultiGetOperationCallback;
import net.spy.memcached.ops.MultiGetsOperationCallback;
import net.spy.memcached.ops.MultiReplicaGetOperationCallback;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.NoopOperation;
import net.spy.memcached.ops.ObserveOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.ReplicaGetOperation;
import net.spy.memcached.ops.ReplicaGetsOperation;
import net.spy.memcached.ops.SASLAuthOperation;
import net.spy.memcached.ops.SASLMechsOperation;
import net.spy.memcached.ops.SASLStepOperation;
import net.spy.memcached.ops.SetConfigOperation;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.ops.TouchOperation;
import net.spy.memcached.ops.UnlockOperation;
import net.spy.memcached.ops.VersionOperation;
import net.spy.memcached.protocol.binary.ConcatenationOperationImpl;
import net.spy.memcached.protocol.binary.DeleteConfigOperationImpl;
import net.spy.memcached.protocol.binary.DeleteOperationImpl;
import net.spy.memcached.protocol.binary.FlushOperationImpl;
import net.spy.memcached.protocol.binary.GetAndTouchOperationImpl;
import net.spy.memcached.protocol.binary.GetConfigOperationImpl;
import net.spy.memcached.protocol.binary.GetOperationImpl;
import net.spy.memcached.protocol.binary.GetlOperationImpl;
import net.spy.memcached.protocol.binary.GetsOperationImpl;
import net.spy.memcached.protocol.binary.KeyStatsOperationImpl;
import net.spy.memcached.protocol.binary.MultiGetOperationImpl;
import net.spy.memcached.protocol.binary.MutatorOperationImpl;
import net.spy.memcached.protocol.binary.NoopOperationImpl;
import net.spy.memcached.protocol.binary.ObserveOperationImpl;
import net.spy.memcached.protocol.binary.ReplicaGetOperationImpl;
import net.spy.memcached.protocol.binary.ReplicaGetsOperationImpl;
import net.spy.memcached.protocol.binary.SASLAuthOperationImpl;
import net.spy.memcached.protocol.binary.SASLMechsOperationImpl;
import net.spy.memcached.protocol.binary.SASLStepOperationImpl;
import net.spy.memcached.protocol.binary.SetConfigOperationImpl;
import net.spy.memcached.protocol.binary.StatsOperationImpl;
import net.spy.memcached.protocol.binary.StoreOperationImpl;
import net.spy.memcached.protocol.binary.TapAckOperationImpl;
import net.spy.memcached.protocol.binary.TapBackfillOperationImpl;
import net.spy.memcached.protocol.binary.TapCustomOperationImpl;
import net.spy.memcached.protocol.binary.TapDumpOperationImpl;
import net.spy.memcached.protocol.binary.TouchOperationImpl;
import net.spy.memcached.protocol.binary.UnlockOperationImpl;
import net.spy.memcached.protocol.binary.VersionOperationImpl;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.TapOpcode;

public class BinaryOperationFactory
extends BaseOperationFactory {
    @Override
    public DeleteOperation delete(String key, DeleteOperation.Callback operationCallback) {
        return new DeleteOperationImpl(key, operationCallback);
    }

    @Override
    public DeleteOperation delete(String key, long cas, DeleteOperation.Callback operationCallback) {
        return new DeleteOperationImpl(key, cas, operationCallback);
    }

    @Override
    public UnlockOperation unlock(String key, long casId, OperationCallback cb) {
        return new UnlockOperationImpl(key, casId, cb);
    }

    @Override
    public ObserveOperation observe(String key, long casId, int index, ObserveOperation.Callback cb) {
        return new ObserveOperationImpl(key, casId, index, (OperationCallback)cb);
    }

    @Override
    public FlushOperation flush(int delay, OperationCallback cb) {
        return new FlushOperationImpl(cb);
    }

    @Override
    public GetAndTouchOperation getAndTouch(String key, int expiration, GetAndTouchOperation.Callback cb) {
        return new GetAndTouchOperationImpl(key, expiration, cb);
    }

    @Override
    public GetOperation get(String key, GetOperation.Callback callback) {
        return new GetOperationImpl(key, callback);
    }

    @Override
    public ReplicaGetOperation replicaGet(String key, int index, ReplicaGetOperation.Callback callback) {
        return new ReplicaGetOperationImpl(key, index, callback);
    }

    @Override
    public ReplicaGetsOperation replicaGets(String key, int index, ReplicaGetsOperation.Callback callback) {
        return new ReplicaGetsOperationImpl(key, index, callback);
    }

    @Override
    public GetOperation get(Collection<String> value, GetOperation.Callback cb) {
        return new MultiGetOperationImpl(value, cb);
    }

    @Override
    public GetlOperation getl(String key, int exp, GetlOperation.Callback cb) {
        return new GetlOperationImpl(key, exp, cb);
    }

    @Override
    public GetsOperation gets(String key, GetsOperation.Callback cb) {
        return new GetsOperationImpl(key, cb);
    }

    @Override
    public StatsOperation keyStats(String key, StatsOperation.Callback cb) {
        return new KeyStatsOperationImpl(key, cb);
    }

    @Override
    public GetConfigOperation getConfig(ConfigurationType type, GetConfigOperation.Callback callback) {
        return new GetConfigOperationImpl(type, callback);
    }

    @Override
    public SetConfigOperation setConfig(ConfigurationType type, int flags, byte[] data, OperationCallback cb) {
        return new SetConfigOperationImpl(type, flags, data, cb);
    }

    @Override
    public DeleteConfigOperation deleteConfig(ConfigurationType type, OperationCallback cb) {
        return new DeleteConfigOperationImpl(type, cb);
    }

    @Override
    public MutatorOperation mutate(Mutator m, String key, long by, long def, int exp, OperationCallback cb) {
        return new MutatorOperationImpl(m, key, by, def, exp, cb);
    }

    @Override
    public StatsOperation stats(String arg, StatsOperation.Callback cb) {
        return new StatsOperationImpl(arg, cb);
    }

    @Override
    public StoreOperation store(StoreType storeType, String key, int flags, int exp, byte[] data, StoreOperation.Callback cb) {
        return new StoreOperationImpl(storeType, key, flags, exp, data, 0L, cb);
    }

    @Override
    public TouchOperation touch(String key, int expiration, OperationCallback cb) {
        return new TouchOperationImpl(key, expiration, cb);
    }

    @Override
    public VersionOperation version(OperationCallback cb) {
        return new VersionOperationImpl(cb);
    }

    @Override
    public NoopOperation noop(OperationCallback cb) {
        return new NoopOperationImpl(cb);
    }

    @Override
    public CASOperation cas(StoreType type, String key, long casId, int flags, int exp, byte[] data, StoreOperation.Callback cb) {
        return new StoreOperationImpl(type, key, flags, exp, data, casId, cb);
    }

    @Override
    public ConcatenationOperation cat(ConcatenationType catType, long casId, String key, byte[] data, OperationCallback cb) {
        return new ConcatenationOperationImpl(catType, key, data, casId, cb);
    }

    @Override
    protected Collection<? extends Operation> cloneGet(KeyedOperation op) {
        ArrayList<KeyedOperation> rv = new ArrayList<KeyedOperation>();
        MultiGetOperationCallback getCb = null;
        MultiGetsOperationCallback getsCb = null;
        MultiReplicaGetOperationCallback replicaGetCb = null;
        if (op.getCallback() instanceof GetOperation.Callback) {
            getCb = new MultiGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else if (op.getCallback() instanceof ReplicaGetOperation.Callback) {
            replicaGetCb = new MultiReplicaGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else {
            getsCb = new MultiGetsOperationCallback(op.getCallback(), op.getKeys().size());
        }
        for (String k : op.getKeys()) {
            if (getCb != null) {
                rv.add(this.get(k, (GetOperation.Callback)getCb));
                continue;
            }
            if (getsCb != null) {
                rv.add(this.gets(k, getsCb));
                continue;
            }
            rv.add(this.replicaGet(k, ((ReplicaGetOperationImpl)op).getReplicaIndex(), replicaGetCb));
        }
        return rv;
    }

    @Override
    public SASLAuthOperation saslAuth(String[] mech, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLAuthOperationImpl(mech, serverName, props, cbh, cb);
    }

    @Override
    public SASLMechsOperation saslMechs(OperationCallback cb) {
        return new SASLMechsOperationImpl(cb);
    }

    @Override
    public SASLStepOperation saslStep(String[] mech, byte[] challenge, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLStepOperationImpl(mech, challenge, serverName, props, cbh, cb);
    }

    @Override
    public TapOperation tapBackfill(String id, long date, OperationCallback cb) {
        return new TapBackfillOperationImpl(id, date, cb);
    }

    @Override
    public TapOperation tapCustom(String id, RequestMessage message, OperationCallback cb) {
        return new TapCustomOperationImpl(id, message, cb);
    }

    @Override
    public TapOperation tapAck(TapOpcode opcode, int opaque, OperationCallback cb) {
        return new TapAckOperationImpl(opcode, opaque, cb);
    }

    @Override
    public TapOperation tapDump(String id, OperationCallback cb) {
        return new TapDumpOperationImpl(id, cb);
    }
}

