/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.SessionMonitor;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class AcquireLockOptions {
    private final String partitionKey;
    private final Optional<String> sortKey;
    private final Optional<ByteBuffer> data;
    private final Boolean replaceData;
    private final Boolean deleteLockOnRelease;
    private final Long refreshPeriod;
    private final Long additionalTimeToWaitForLock;
    private final TimeUnit timeUnit;
    private final Map<String, AttributeValue> additionalAttributes;
    private final Optional<SessionMonitor> sessionMonitor;
    private final Optional<RequestMetricCollector> requestMetricCollector;

    public static AcquireLockOptionsBuilder builder(String partitionKey) {
        return new AcquireLockOptionsBuilder(partitionKey);
    }

    private AcquireLockOptions(String partitionKey, Optional<String> sortKey, Optional<ByteBuffer> data, Boolean replaceData, Boolean deleteLockOnRelease, Long refreshPeriod, Long additionalTimeToWaitForLock, TimeUnit timeUnit, Map<String, AttributeValue> additionalAttributes, Optional<SessionMonitor> sessionMonitor, Optional<RequestMetricCollector> requestMetricCollector) {
        this.partitionKey = partitionKey;
        this.sortKey = sortKey;
        this.data = data;
        this.replaceData = replaceData;
        this.deleteLockOnRelease = deleteLockOnRelease;
        this.refreshPeriod = refreshPeriod;
        this.additionalTimeToWaitForLock = additionalTimeToWaitForLock;
        this.timeUnit = timeUnit;
        this.additionalAttributes = additionalAttributes;
        this.sessionMonitor = sessionMonitor;
        this.requestMetricCollector = requestMetricCollector;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    Optional<String> getSortKey() {
        return this.sortKey;
    }

    Optional<ByteBuffer> getData() {
        return this.data;
    }

    Boolean getReplaceData() {
        return this.replaceData;
    }

    Boolean getDeleteLockOnRelease() {
        return this.deleteLockOnRelease;
    }

    Long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    Long getAdditionalTimeToWaitForLock() {
        return this.additionalTimeToWaitForLock;
    }

    TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    Map<String, AttributeValue> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    Optional<SessionMonitor> getSessionMonitor() {
        return this.sessionMonitor;
    }

    Optional<RequestMetricCollector> getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AcquireLockOptions)) {
            return false;
        }
        AcquireLockOptions otherOptions = (AcquireLockOptions)other;
        return Objects.equals(this.partitionKey, otherOptions.partitionKey) && Objects.equals(this.sortKey, otherOptions.sortKey) && Objects.equals(this.data, otherOptions.data) && Objects.equals(this.replaceData, otherOptions.replaceData) && Objects.equals(this.deleteLockOnRelease, otherOptions.deleteLockOnRelease) && Objects.equals(this.refreshPeriod, otherOptions.refreshPeriod) && Objects.equals(this.additionalTimeToWaitForLock, otherOptions.additionalTimeToWaitForLock) && Objects.equals((Object)this.timeUnit, (Object)otherOptions.timeUnit) && Objects.equals(this.additionalAttributes, otherOptions.additionalAttributes) && Objects.equals(this.sessionMonitor, otherOptions.sessionMonitor) && Objects.equals(this.requestMetricCollector, otherOptions.requestMetricCollector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionKey, this.sortKey, this.data, this.replaceData, this.deleteLockOnRelease, this.refreshPeriod, this.additionalTimeToWaitForLock, this.timeUnit, this.additionalAttributes, this.sessionMonitor, this.requestMetricCollector});
    }

    public static class AcquireLockOptionsBuilder {
        private String partitionKey;
        private Optional<String> sortKey;
        private Optional<ByteBuffer> data;
        private Boolean replaceData;
        private Boolean deleteLockOnRelease;
        private Long refreshPeriod;
        private Long additionalTimeToWaitForLock;
        private TimeUnit timeUnit;
        private Map<String, AttributeValue> additionalAttributes;
        private Optional<RequestMetricCollector> requestMetricCollector;
        private long safeTimeWithoutHeartbeat;
        private Optional<Runnable> sessionMonitorCallback;
        private boolean isSessionMonitorSet = false;

        AcquireLockOptionsBuilder(String partitionKey) {
            this.partitionKey = partitionKey;
            this.additionalAttributes = new HashMap<String, AttributeValue>();
            this.sortKey = Optional.empty();
            this.requestMetricCollector = Optional.empty();
            this.data = Optional.empty();
            this.replaceData = true;
            this.deleteLockOnRelease = true;
        }

        public AcquireLockOptionsBuilder withSortKey(String sortKey) {
            this.sortKey = Optional.of(sortKey);
            return this;
        }

        public AcquireLockOptionsBuilder withData(ByteBuffer data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public AcquireLockOptionsBuilder withReplaceData(Boolean replaceData) {
            this.replaceData = replaceData;
            return this;
        }

        public AcquireLockOptionsBuilder withDeleteLockOnRelease(Boolean deleteLockOnRelease) {
            this.deleteLockOnRelease = deleteLockOnRelease;
            return this;
        }

        public AcquireLockOptionsBuilder withRefreshPeriod(Long refreshPeriod) {
            this.refreshPeriod = refreshPeriod;
            return this;
        }

        public AcquireLockOptionsBuilder withAdditionalTimeToWaitForLock(Long additionalTimeToWaitForLock) {
            this.additionalTimeToWaitForLock = additionalTimeToWaitForLock;
            return this;
        }

        public AcquireLockOptionsBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public AcquireLockOptionsBuilder withAdditionalAttributes(Map<String, AttributeValue> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public AcquireLockOptionsBuilder withSessionMonitor(long safeTimeWithoutHeartbeat, Optional<Runnable> sessionMonitorCallback) {
            this.safeTimeWithoutHeartbeat = safeTimeWithoutHeartbeat;
            this.sessionMonitorCallback = sessionMonitorCallback;
            this.isSessionMonitorSet = true;
            return this;
        }

        public AcquireLockOptionsBuilder withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = Optional.ofNullable(requestMetricCollector);
            return this;
        }

        public AcquireLockOptions build() {
            Optional<Object> sessionMonitor;
            if (this.isSessionMonitorSet) {
                Objects.requireNonNull(this.timeUnit, "timeUnit must not be null if sessionMonitor is non-null");
                sessionMonitor = Optional.of(new SessionMonitor(this.timeUnit.toMillis(this.safeTimeWithoutHeartbeat), this.sessionMonitorCallback));
            } else {
                sessionMonitor = Optional.empty();
            }
            return new AcquireLockOptions(this.partitionKey, this.sortKey, this.data, this.replaceData, this.deleteLockOnRelease, this.refreshPeriod, this.additionalTimeToWaitForLock, this.timeUnit, this.additionalAttributes, sessionMonitor, this.requestMetricCollector);
        }

        public String toString() {
            return "AcquireLockOptions.AcquireLockOptionsBuilder(key=" + this.partitionKey + ", sortKey=" + this.sortKey + ", data=" + this.data + ", replaceData=" + this.replaceData + ", deleteLockOnRelease=" + this.deleteLockOnRelease + ", refreshPeriod=" + this.refreshPeriod + ", additionalTimeToWaitForLock=" + this.additionalTimeToWaitForLock + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", additionalAttributes=" + this.additionalAttributes + ", safeTimeWithoutHeartbeat=" + this.safeTimeWithoutHeartbeat + ", sessionMonitorCallback=" + this.sessionMonitorCallback + ", requestMetricCollector=" + this.requestMetricCollector + ")";
        }
    }
}

