/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.events.modules;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.joda.JodaModule;
import com.amazonaws.services.lambda.runtime.serialization.util.SerializeUtil;
import java.io.IOException;

public class DateTimeModule
extends JodaModule {
    public DateTimeModule(ClassLoader classLoader) {
        Class dateTimeClass = SerializeUtil.loadCustomerClass("org.joda.time.DateTime", classLoader);
        this.addSerializer(dateTimeClass, this.getSerializer(dateTimeClass, classLoader));
        this.addDeserializer(dateTimeClass, this.getDeserializer(dateTimeClass));
    }

    private <T> JsonSerializer<T> getSerializer(Class<T> dateTimeClass, final ClassLoader classLoader) {
        return new JsonSerializer<T>(){

            @Override
            public void serialize(T dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(SerializeUtil.serializeDateTime(dateTime, classLoader));
            }
        };
    }

    private <T> JsonDeserializer<T> getDeserializer(final Class<T> dateTimeClass) {
        return new JsonDeserializer<T>(){

            @Override
            public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                return SerializeUtil.deserializeDateTime(dateTimeClass, jsonParser.getValueAsString());
            }
        };
    }
}

