/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.events;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.CloudFormationCustomResourceEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.CloudFrontEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.CloudWatchLogsEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.CodeCommitEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.ConnectEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.DynamodbEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.DynamodbTimeWindowEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.KinesisEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.KinesisTimeWindowEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.SNSEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.SQSEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.ScheduledEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.mixins.SecretsManagerRotationEventMixin;
import com.amazonaws.services.lambda.runtime.serialization.events.modules.DateModule;
import com.amazonaws.services.lambda.runtime.serialization.events.modules.DateTimeModule;
import com.amazonaws.services.lambda.runtime.serialization.events.serializers.OrgJsonSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.serializers.S3EventSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.JacksonFactory;
import com.amazonaws.services.lambda.runtime.serialization.util.ReflectUtil;
import com.amazonaws.services.lambda.runtime.serialization.util.SerializeUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LambdaEventSerializers {
    private static final List<String> SUPPORTED_EVENTS = Stream.of("com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent", "com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent", "com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent", "com.amazonaws.services.lambda.runtime.events.CloudFrontEvent", "com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent", "com.amazonaws.services.lambda.runtime.events.CodeCommitEvent", "com.amazonaws.services.lambda.runtime.events.CognitoEvent", "com.amazonaws.services.lambda.runtime.events.ConfigEvent", "com.amazonaws.services.lambda.runtime.events.ConnectEvent", "com.amazonaws.services.lambda.runtime.events.DynamodbEvent", "com.amazonaws.services.lambda.runtime.events.DynamodbTimeWindowEvent", "com.amazonaws.services.lambda.runtime.events.IoTButtonEvent", "com.amazonaws.services.lambda.runtime.events.KinesisEvent", "com.amazonaws.services.lambda.runtime.events.KinesisTimeWindowEvent", "com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent", "com.amazonaws.services.lambda.runtime.events.LambdaDestinationEvent", "com.amazonaws.services.lambda.runtime.events.LexEvent", "com.amazonaws.services.lambda.runtime.events.ScheduledEvent", "com.amazonaws.services.lambda.runtime.events.SecretsManagerRotationEvent", "com.amazonaws.services.s3.event.S3EventNotification", "com.amazonaws.services.lambda.runtime.events.models.s3.S3EventNotification", "com.amazonaws.services.lambda.runtime.events.S3Event", "com.amazonaws.services.lambda.runtime.events.SNSEvent", "com.amazonaws.services.lambda.runtime.events.SQSEvent").collect(Collectors.toList());
    private static final Map<String, OrgJsonSerializer> SERIALIZER_MAP = Stream.of(new AbstractMap.SimpleEntry("com.amazonaws.services.s3.event.S3EventNotification", new S3EventSerializer()), new AbstractMap.SimpleEntry("com.amazonaws.services.lambda.runtime.events.models.s3.S3EventNotification", new S3EventSerializer()), new AbstractMap.SimpleEntry("com.amazonaws.services.lambda.runtime.events.S3Event", new S3EventSerializer())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final Map<String, Class> MIXIN_MAP = Stream.of(new AbstractMap.SimpleEntry<String, Class<CloudFormationCustomResourceEventMixin>>("com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent", CloudFormationCustomResourceEventMixin.class), new AbstractMap.SimpleEntry<String, Class<CloudFrontEventMixin>>("com.amazonaws.services.lambda.runtime.events.CloudFrontEvent", CloudFrontEventMixin.class), new AbstractMap.SimpleEntry<String, Class<CloudWatchLogsEventMixin>>("com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent", CloudWatchLogsEventMixin.class), new AbstractMap.SimpleEntry<String, Class<CodeCommitEventMixin>>("com.amazonaws.services.lambda.runtime.events.CodeCommitEvent", CodeCommitEventMixin.class), new AbstractMap.SimpleEntry<String, Class<CodeCommitEventMixin.RecordMixin>>("com.amazonaws.services.lambda.runtime.events.CodeCommitEvent$Record", CodeCommitEventMixin.RecordMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent", ConnectEventMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin.DetailsMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$Details", ConnectEventMixin.DetailsMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin.ContactDataMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$ContactData", ConnectEventMixin.ContactDataMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin.CustomerEndpointMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$CustomerEndpoint", ConnectEventMixin.CustomerEndpointMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin.QueueMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$Queue", ConnectEventMixin.QueueMixin.class), new AbstractMap.SimpleEntry<String, Class<ConnectEventMixin.SystemEndpointMixin>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$SystemEndpoint", ConnectEventMixin.SystemEndpointMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin>>("com.amazonaws.services.lambda.runtime.events.DynamodbEvent", DynamodbEventMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin.DynamodbStreamRecordMixin>>("com.amazonaws.services.lambda.runtime.events.DynamodbEvent$DynamodbStreamRecord", DynamodbEventMixin.DynamodbStreamRecordMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin.StreamRecordMixin>>("com.amazonaws.services.dynamodbv2.model.StreamRecord", DynamodbEventMixin.StreamRecordMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin.StreamRecordMixin>>("com.amazonaws.services.lambda.runtime.events.models.dynamodb.StreamRecord", DynamodbEventMixin.StreamRecordMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin.AttributeValueMixin>>("com.amazonaws.services.dynamodbv2.model.AttributeValue", DynamodbEventMixin.AttributeValueMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbEventMixin.AttributeValueMixin>>("com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue", DynamodbEventMixin.AttributeValueMixin.class), new AbstractMap.SimpleEntry<String, Class<DynamodbTimeWindowEventMixin>>("com.amazonaws.services.lambda.runtime.events.DynamodbTimeWindowEvent", DynamodbTimeWindowEventMixin.class), new AbstractMap.SimpleEntry<String, Class<KinesisEventMixin>>("com.amazonaws.services.lambda.runtime.events.KinesisEvent", KinesisEventMixin.class), new AbstractMap.SimpleEntry<String, Class<KinesisEventMixin.RecordMixin>>("com.amazonaws.services.lambda.runtime.events.KinesisEvent$Record", KinesisEventMixin.RecordMixin.class), new AbstractMap.SimpleEntry<String, Class<KinesisTimeWindowEventMixin>>("com.amazonaws.services.lambda.runtime.events.KinesisTimeWindowEvent", KinesisTimeWindowEventMixin.class), new AbstractMap.SimpleEntry<String, Class<ScheduledEventMixin>>("com.amazonaws.services.lambda.runtime.events.ScheduledEvent", ScheduledEventMixin.class), new AbstractMap.SimpleEntry<String, Class<SecretsManagerRotationEventMixin>>("com.amazonaws.services.lambda.runtime.events.SecretsManagerRotationEvent", SecretsManagerRotationEventMixin.class), new AbstractMap.SimpleEntry<String, Class<SNSEventMixin>>("com.amazonaws.services.lambda.runtime.events.SNSEvent", SNSEventMixin.class), new AbstractMap.SimpleEntry<String, Class<SNSEventMixin.SNSRecordMixin>>("com.amazonaws.services.lambda.runtime.events.SNSEvent$SNSRecord", SNSEventMixin.SNSRecordMixin.class), new AbstractMap.SimpleEntry<String, Class<SQSEventMixin>>("com.amazonaws.services.lambda.runtime.events.SQSEvent", SQSEventMixin.class), new AbstractMap.SimpleEntry<String, Class<SQSEventMixin.SQSMessageMixin>>("com.amazonaws.services.lambda.runtime.events.SQSEvent$SQSMessage", SQSEventMixin.SQSMessageMixin.class)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final Map<String, List<? extends NestedClass>> NESTED_CLASS_MAP = Stream.of(new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.CodeCommitEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.CodeCommitEvent$Record"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.CognitoEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.CognitoEvent$DatasetRecord"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.ConnectEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.ConnectEvent$Details"), new NestedClass("com.amazonaws.services.lambda.runtime.events.ConnectEvent$ContactData"), new NestedClass("com.amazonaws.services.lambda.runtime.events.ConnectEvent$CustomerEndpoint"), new NestedClass("com.amazonaws.services.lambda.runtime.events.ConnectEvent$Queue"), new NestedClass("com.amazonaws.services.lambda.runtime.events.ConnectEvent$SystemEndpoint"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.DynamodbEvent", Arrays.asList(new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue", "com.amazonaws.services.dynamodbv2.model.AttributeValue"), new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.StreamRecord", "com.amazonaws.services.dynamodbv2.model.StreamRecord"), new NestedClass("com.amazonaws.services.lambda.runtime.events.DynamodbEvent$DynamodbStreamRecord"))), new AbstractMap.SimpleEntry<String, List<AlternateNestedClass>>("com.amazonaws.services.lambda.runtime.events.DynamodbEvent$DynamodbStreamRecord", Arrays.asList(new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue", "com.amazonaws.services.dynamodbv2.model.AttributeValue"), new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.StreamRecord", "com.amazonaws.services.dynamodbv2.model.StreamRecord"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.DynamodbTimeWindowEvent", Arrays.asList(new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue", "com.amazonaws.services.dynamodbv2.model.AttributeValue"), new AlternateNestedClass("com.amazonaws.services.lambda.runtime.events.models.dynamodb.StreamRecord", "com.amazonaws.services.dynamodbv2.model.StreamRecord"), new NestedClass("com.amazonaws.services.lambda.runtime.events.DynamodbEvent$DynamodbStreamRecord"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.KinesisEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.KinesisEvent$Record"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.SNSEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.SNSEvent$SNSRecord"))), new AbstractMap.SimpleEntry<String, List<NestedClass>>("com.amazonaws.services.lambda.runtime.events.SQSEvent", Arrays.asList(new NestedClass("com.amazonaws.services.lambda.runtime.events.SQSEvent$SQSMessage")))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final Map<String, PropertyNamingStrategy> NAMING_STRATEGY_MAP = Stream.of(new AbstractMap.SimpleEntry<String, PropertyNamingStrategy.PascalCaseStrategy>("com.amazonaws.services.lambda.runtime.events.SNSEvent", new PropertyNamingStrategy.PascalCaseStrategy()), new AbstractMap.SimpleEntry<String, PropertyNamingStrategy.PascalCaseStrategy>("com.amazonaws.services.lambda.runtime.events.ConnectEvent$Queue", new PropertyNamingStrategy.PascalCaseStrategy())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));

    public static boolean isLambdaSupportedEvent(String className) {
        return SUPPORTED_EVENTS.contains(className);
    }

    public static <T> PojoSerializer<T> serializerFor(Class<T> eventClass, ClassLoader classLoader) {
        if (SERIALIZER_MAP.containsKey(eventClass.getName())) {
            return SERIALIZER_MAP.get(eventClass.getName()).withClass(eventClass).withClassLoader(classLoader);
        }
        JacksonFactory factory = JacksonFactory.getInstance();
        if (MIXIN_MAP.containsKey(eventClass.getName())) {
            factory = factory.withMixin(eventClass, MIXIN_MAP.get(eventClass.getName()));
        }
        if (NESTED_CLASS_MAP.containsKey(eventClass.getName())) {
            List<? extends NestedClass> nestedClasses = NESTED_CLASS_MAP.get(eventClass.getName());
            for (NestedClass nestedClass : nestedClasses) {
                if (!MIXIN_MAP.containsKey(nestedClass.className)) continue;
                factory = LambdaEventSerializers.tryLoadingNestedClass(classLoader, factory, nestedClass);
            }
        }
        factory.getMapper().registerModules(new DateModule(), new DateTimeModule(classLoader));
        if (NAMING_STRATEGY_MAP.containsKey(eventClass.getName())) {
            factory = factory.withNamingStrategy(NAMING_STRATEGY_MAP.get(eventClass.getName()));
        }
        return factory.getSerializer(eventClass);
    }

    private static JacksonFactory tryLoadingNestedClass(ClassLoader classLoader, JacksonFactory factory, NestedClass nestedClass) {
        Class mixinClazz;
        Class eventClazz;
        try {
            eventClazz = SerializeUtil.loadCustomerClass(nestedClass.getClassName(), classLoader);
            mixinClazz = MIXIN_MAP.get(nestedClass.getClassName());
        }
        catch (ReflectUtil.ReflectException e) {
            if (nestedClass instanceof AlternateNestedClass) {
                AlternateNestedClass alternateNestedClass = (AlternateNestedClass)nestedClass;
                eventClazz = SerializeUtil.loadCustomerClass(alternateNestedClass.getAlternateClassName(), classLoader);
                mixinClazz = MIXIN_MAP.get(alternateNestedClass.getAlternateClassName());
            }
            throw e;
        }
        return factory.withMixin(eventClazz, mixinClazz);
    }

    private static class AlternateNestedClass
    extends NestedClass {
        private final String alternateClassName;

        private AlternateNestedClass(String className, String alternateClassName) {
            super(className);
            this.alternateClassName = alternateClassName;
        }

        private String getAlternateClassName() {
            return this.alternateClassName;
        }
    }

    private static class NestedClass {
        private final String className;

        protected NestedClass(String className) {
            this.className = className;
        }

        protected String getClassName() {
            return this.className;
        }
    }
}

