/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.UserFault;
import com.amazonaws.services.lambda.runtime.api.client.logging.LambdaContextLogger;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.DtoSerializers;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaError;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeApiClient;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeClientException;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeClientMaxRetriesExceededException;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.NativeClient;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.dto.InvocationRequest;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class LambdaRuntimeApiClientImpl
implements LambdaRuntimeApiClient {
    static final String USER_AGENT = String.format("aws-lambda-java/%s-%s", System.getProperty("java.vendor.version"), LambdaRuntimeApiClientImpl.class.getPackage().getImplementationVersion());
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String XRAY_ERROR_CAUSE_HEADER = "Lambda-Runtime-Function-XRay-Error-Cause";
    private static final String ERROR_TYPE_HEADER = "Lambda-Runtime-Function-Error-Type";
    private static final int XRAY_ERROR_CAUSE_MAX_HEADER_SIZE = 0x100000;
    private static final long MAX_BACKOFF_PERIOD_MS = 32768L;
    private static final long INITIAL_BACKOFF_PERIOD_MS = 100L;
    private static final int MAX_NUMBER_OF_RETRIALS = 5;
    private final String baseUrl;
    private final String invocationEndpoint;

    public LambdaRuntimeApiClientImpl(String hostnameAndPort) {
        Objects.requireNonNull(hostnameAndPort, "hostnameAndPort cannot be null");
        this.baseUrl = "http://" + hostnameAndPort;
        this.invocationEndpoint = this.baseUrl + "/2018-06-01/runtime/invocation/";
        NativeClient.init(hostnameAndPort);
    }

    @Override
    public void reportInitError(LambdaError error) throws IOException {
        String endpoint = this.baseUrl + "/2018-06-01/runtime/init/error";
        this.reportLambdaError(endpoint, error, 0x100000);
    }

    @Override
    public InvocationRequest nextInvocation() {
        return NativeClient.next();
    }

    public static <T> T getSupplierResultWithExponentialBackoff(LambdaContextLogger lambdaLogger, long initialDelayMS, long maxBackoffPeriodMS, int maxNumOfAttempts, Supplier<T> supplier, Function<Exception, String> exceptionMessageComposer, Exception maxRetriesException) throws Exception {
        long delayMS = initialDelayMS;
        for (int attempts = 0; attempts < maxNumOfAttempts; ++attempts) {
            boolean isFirstAttempt = attempts == 0;
            boolean isLastAttempt = attempts + 1 == maxNumOfAttempts;
            try {
                return supplier.get();
            }
            catch (Exception e) {
                String logMessage = exceptionMessageComposer.apply(e);
                if (!isLastAttempt) {
                    logMessage = logMessage + String.format("\nRetrying%s", isFirstAttempt ? "." : String.format(" in %d ms.", delayMS));
                }
                lambdaLogger.log(logMessage, lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
                if (isLastAttempt) {
                    throw maxRetriesException;
                }
                if (isFirstAttempt) continue;
                try {
                    Thread.sleep(delayMS);
                    delayMS = Math.min(delayMS * 2L, maxBackoffPeriodMS);
                }
                catch (InterruptedException e2) {
                    Thread.interrupted();
                }
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public InvocationRequest nextInvocationWithExponentialBackoff(LambdaContextLogger lambdaLogger) throws Exception {
        Supplier<InvocationRequest> nextInvocationSupplier = () -> this.nextInvocation();
        Function<Exception, String> exceptionMessageComposer = e -> String.format("Runtime Loop on Thread ID: %s Failed to fetch next invocation.\n%s", Thread.currentThread().getName(), UserFault.trace(e));
        return LambdaRuntimeApiClientImpl.getSupplierResultWithExponentialBackoff(lambdaLogger, 100L, 32768L, 5, nextInvocationSupplier, exceptionMessageComposer, new LambdaRuntimeClientMaxRetriesExceededException("Get Next Invocation"));
    }

    @Override
    public void reportInvocationSuccess(String requestId, byte[] response) {
        NativeClient.postInvocationResponse(requestId.getBytes(StandardCharsets.UTF_8), response);
    }

    @Override
    public void reportInvocationError(String requestId, LambdaError error) throws IOException {
        String endpoint = this.invocationEndpoint + requestId + "/error";
        this.reportLambdaError(endpoint, error, 0x100000);
    }

    @Override
    public void restoreNext() throws IOException {
        String endpoint = this.baseUrl + "/2018-06-01/runtime/restore/next";
        int responseCode = this.doGet(endpoint);
        if (responseCode != 200) {
            throw new LambdaRuntimeClientException(endpoint, responseCode);
        }
    }

    @Override
    public void reportRestoreError(LambdaError error) throws IOException {
        String endpoint = this.baseUrl + "/2018-06-01/runtime/restore/error";
        this.reportLambdaError(endpoint, error, 0x100000);
    }

    void reportLambdaError(String endpoint, LambdaError error, int maxXrayHeaderSize) throws IOException {
        byte[] payload;
        int responseCode;
        byte[] xRayErrorCauseJson;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(ERROR_TYPE_HEADER, error.errorType.getRapidError());
        if (error.xRayErrorCause != null && (xRayErrorCauseJson = DtoSerializers.serialize(error.xRayErrorCause)) != null && xRayErrorCauseJson.length < maxXrayHeaderSize) {
            headers.put(XRAY_ERROR_CAUSE_HEADER, new String(xRayErrorCauseJson));
        }
        if ((responseCode = this.doPost(endpoint, headers, payload = DtoSerializers.serialize(error.errorRequest))) != 202) {
            throw new LambdaRuntimeClientException(endpoint, responseCode);
        }
    }

    private int doPost(String endpoint, Map<String, String> headers, byte[] payload) throws IOException {
        URL url = this.createUrl(endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", DEFAULT_CONTENT_TYPE);
        conn.setRequestProperty("User-Agent", USER_AGENT);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        conn.setFixedLengthStreamingMode(payload.length);
        conn.setDoOutput(true);
        try (OutputStream outputStream = conn.getOutputStream();){
            outputStream.write(payload);
        }
        int responseCode = conn.getResponseCode();
        this.closeInputStreamQuietly(conn);
        return responseCode;
    }

    private int doGet(String endpoint) throws IOException {
        URL url = this.createUrl(endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", USER_AGENT);
        int responseCode = conn.getResponseCode();
        this.closeInputStreamQuietly(conn);
        return responseCode;
    }

    private URL createUrl(String endpoint) {
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeInputStreamQuietly(HttpURLConnection conn) {
        InputStream inputStream;
        try {
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            return;
        }
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

