/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.api.client.api.LambdaContext;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogFormatter;
import com.amazonaws.services.lambda.runtime.api.client.logging.StructuredLogMessage;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.GsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class JsonLogFormatter
implements LogFormatter {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));
    private final PojoSerializer<StructuredLogMessage> serializer = GsonFactory.getInstance().getSerializer(StructuredLogMessage.class);
    private ThreadLocal<LambdaContext> lambdaContext = new ThreadLocal();

    @Override
    public String format(String message, LogLevel logLevel) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StructuredLogMessage msg = this.createLogMessage(message, logLevel);
        this.serializer.toJson((Object)msg, (OutputStream)stream);
        stream.write(10);
        return new String(stream.toByteArray(), StandardCharsets.UTF_8);
    }

    private StructuredLogMessage createLogMessage(String message, LogLevel logLevel) {
        StructuredLogMessage msg = new StructuredLogMessage();
        msg.timestamp = dateFormatter.format(LocalDateTime.now());
        msg.message = message;
        msg.level = logLevel;
        LambdaContext lambdaContextForCurrentThread = this.lambdaContext.get();
        if (lambdaContextForCurrentThread != null) {
            msg.AWSRequestId = lambdaContextForCurrentThread.getAwsRequestId();
            msg.tenantId = lambdaContextForCurrentThread.getTenantId();
        }
        return msg;
    }

    @Override
    public void setLambdaContext(LambdaContext context) {
        if (context == null) {
            this.lambdaContext.remove();
        } else {
            this.lambdaContext.set(context);
        }
    }
}

