/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.api.client.logging.AbstractLambdaLogger;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class LambdaContextLogger
extends AbstractLambdaLogger
implements Closeable {
    private static final byte[] NULL_BYTES_VALUE = "null".getBytes(StandardCharsets.UTF_8);
    private final transient LogSink sink;

    public LambdaContextLogger(LogSink sink, LogLevel logLevel, LogFormat logFormat) {
        super(logLevel, logFormat);
        this.sink = sink;
    }

    @Override
    protected void logMessage(byte[] message, LogLevel logLevel) {
        if (message == null) {
            this.sink.log(logLevel, this.logFormat, NULL_BYTES_VALUE);
        } else {
            this.sink.log(logLevel, this.logFormat, message);
        }
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }
}

