/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.crac;

import com.amazonaws.services.lambda.crac.CheckpointException;
import com.amazonaws.services.lambda.crac.Context;
import com.amazonaws.services.lambda.crac.Resource;
import com.amazonaws.services.lambda.crac.RestoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class ContextImpl
extends Context<Resource> {
    private volatile long order = -1L;
    private final WeakHashMap<Resource, Long> checkpointQueue = new WeakHashMap();

    @Override
    public synchronized void beforeCheckpoint(Context<? extends Resource> context) throws CheckpointException {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        for (Resource resource : this.getCheckpointQueueReverseOrderOfRegistration()) {
            try {
                resource.beforeCheckpoint(this);
            }
            catch (CheckpointException checkpointException) {
                Collections.addAll(exceptionsThrown, checkpointException.getSuppressed());
            }
            catch (Exception exception) {
                exceptionsThrown.add(exception);
            }
        }
        if (!exceptionsThrown.isEmpty()) {
            CheckpointException checkpointException = new CheckpointException();
            for (Throwable throwable : exceptionsThrown) {
                checkpointException.addSuppressed(throwable);
            }
            throw checkpointException;
        }
    }

    @Override
    public synchronized void afterRestore(Context<? extends Resource> context) throws RestoreException {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        for (Resource resource : this.getCheckpointQueueForwardOrderOfRegistration()) {
            try {
                resource.afterRestore(this);
            }
            catch (RestoreException restoreException) {
                Collections.addAll(exceptionsThrown, restoreException.getSuppressed());
            }
            catch (Exception exception) {
                exceptionsThrown.add(exception);
            }
        }
        if (!exceptionsThrown.isEmpty()) {
            RestoreException restoreException = new RestoreException();
            for (Throwable throwable : exceptionsThrown) {
                restoreException.addSuppressed(throwable);
            }
            throw restoreException;
        }
    }

    @Override
    public synchronized void register(Resource resource) {
        this.checkpointQueue.put(resource, ++this.order);
    }

    private List<Resource> getCheckpointQueueReverseOrderOfRegistration() {
        return this.checkpointQueue.entrySet().stream().sorted((r1, r2) -> (int)((Long)r2.getValue() - (Long)r1.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private List<Resource> getCheckpointQueueForwardOrderOfRegistration() {
        return this.checkpointQueue.entrySet().stream().sorted((r1, r2) -> (int)((Long)r1.getValue() - (Long)r2.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

