/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.InvocationRequest;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.UnknownPlatformException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

class NativeClient {
    private static final String nativeLibPath = "/tmp/.aws-lambda-runtime-interface-client";
    private static final String architecturePathSuffix;
    private static final String supported_arm_architectures = "^(aarch64.*|arm64.*)$";
    private static final String supported_x86_architectures = "^(x8664|amd64|ia32e|em64t|x64|x86_64)$";
    private static final String[] libsToTry;
    private static final Throwable[] exceptions;

    NativeClient() {
    }

    static String getArchIdentifier() {
        String arch = System.getProperty("os.arch");
        if (arch.matches(supported_x86_architectures)) {
            return "x86_64";
        }
        if (arch.matches(supported_arm_architectures)) {
            return "aarch64";
        }
        throw new UnknownPlatformException("architecture not supported: " + arch);
    }

    static native void initializeClient(byte[] var0);

    static native InvocationRequest next();

    static native void postInvocationResponse(byte[] var0, byte[] var1);

    static {
        int i;
        architecturePathSuffix = "/" + NativeClient.getArchIdentifier();
        libsToTry = new String[]{"aws-lambda-runtime-interface-client.glibc.so", "aws-lambda-runtime-interface-client.musl.so"};
        exceptions = new Throwable[libsToTry.length];
        boolean loaded = false;
        for (i = 0; !loaded && i < libsToTry.length; ++i) {
            try (InputStream lib = NativeClient.class.getResourceAsStream(Paths.get(architecturePathSuffix, libsToTry[i]).toString());){
                Files.copy(lib, Paths.get(nativeLibPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                System.load(nativeLibPath);
                loaded = true;
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                NativeClient.exceptions[i] = e;
                continue;
            }
            catch (Exception e) {
                NativeClient.exceptions[i] = e;
            }
        }
        if (!loaded) {
            for (i = 0; i < libsToTry.length; ++i) {
                System.err.printf("Failed to load the native runtime interface client library %s. Exception: %s\n", libsToTry[i], exceptions[i].getMessage());
            }
            System.exit(-1);
        }
        String userAgent = String.format("aws-lambda-java/%s-%s", System.getProperty("java.vendor.version"), NativeClient.class.getPackage().getImplementationVersion());
        NativeClient.initializeClient(userAgent.getBytes());
    }
}

