/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityAsync;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCognitoIdentityAsyncClient
extends AmazonCognitoIdentityClient
implements AmazonCognitoIdentityAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCognitoIdentityAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCognitoIdentityAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(final ListIdentityPoolsRequest listIdentityPoolsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolsResult>(){

            @Override
            public ListIdentityPoolsResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.listIdentityPools(listIdentityPoolsRequest);
            }
        });
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(final ListIdentityPoolsRequest listIdentityPoolsRequest, final AsyncHandler<ListIdentityPoolsRequest, ListIdentityPoolsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolsResult>(){

            @Override
            public ListIdentityPoolsResult call() throws Exception {
                ListIdentityPoolsResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.listIdentityPools(listIdentityPoolsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listIdentityPoolsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(final GetOpenIdTokenRequest getOpenIdTokenRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetOpenIdTokenResult>(){

            @Override
            public GetOpenIdTokenResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.getOpenIdToken(getOpenIdTokenRequest);
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(final GetOpenIdTokenRequest getOpenIdTokenRequest, final AsyncHandler<GetOpenIdTokenRequest, GetOpenIdTokenResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetOpenIdTokenResult>(){

            @Override
            public GetOpenIdTokenResult call() throws Exception {
                GetOpenIdTokenResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getOpenIdToken(getOpenIdTokenRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getOpenIdTokenRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> unlinkIdentityAsync(final UnlinkIdentityRequest unlinkIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCognitoIdentityAsyncClient.this.unlinkIdentity(unlinkIdentityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unlinkIdentityAsync(final UnlinkIdentityRequest unlinkIdentityRequest, final AsyncHandler<UnlinkIdentityRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCognitoIdentityAsyncClient.this.unlinkIdentity(unlinkIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(unlinkIdentityRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(final DescribeIdentityPoolRequest describeIdentityPoolRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolResult>(){

            @Override
            public DescribeIdentityPoolResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.describeIdentityPool(describeIdentityPoolRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(final DescribeIdentityPoolRequest describeIdentityPoolRequest, final AsyncHandler<DescribeIdentityPoolRequest, DescribeIdentityPoolResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolResult>(){

            @Override
            public DescribeIdentityPoolResult call() throws Exception {
                DescribeIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.describeIdentityPool(describeIdentityPoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeIdentityPoolRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetIdResult> getIdAsync(final GetIdRequest getIdRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdResult>(){

            @Override
            public GetIdResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.getId(getIdRequest);
            }
        });
    }

    @Override
    public Future<GetIdResult> getIdAsync(final GetIdRequest getIdRequest, final AsyncHandler<GetIdRequest, GetIdResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdResult>(){

            @Override
            public GetIdResult call() throws Exception {
                GetIdResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getId(getIdRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getIdRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteIdentityPoolAsync(final DeleteIdentityPoolRequest deleteIdentityPoolRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCognitoIdentityAsyncClient.this.deleteIdentityPool(deleteIdentityPoolRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteIdentityPoolAsync(final DeleteIdentityPoolRequest deleteIdentityPoolRequest, final AsyncHandler<DeleteIdentityPoolRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCognitoIdentityAsyncClient.this.deleteIdentityPool(deleteIdentityPoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteIdentityPoolRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(final ListIdentitiesRequest listIdentitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.listIdentities(listIdentitiesRequest);
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(final ListIdentitiesRequest listIdentitiesRequest, final AsyncHandler<ListIdentitiesRequest, ListIdentitiesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                ListIdentitiesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.listIdentities(listIdentitiesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listIdentitiesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(final UpdateIdentityPoolRequest updateIdentityPoolRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateIdentityPoolResult>(){

            @Override
            public UpdateIdentityPoolResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.updateIdentityPool(updateIdentityPoolRequest);
            }
        });
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(final UpdateIdentityPoolRequest updateIdentityPoolRequest, final AsyncHandler<UpdateIdentityPoolRequest, UpdateIdentityPoolResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateIdentityPoolResult>(){

            @Override
            public UpdateIdentityPoolResult call() throws Exception {
                UpdateIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.updateIdentityPool(updateIdentityPoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateIdentityPoolRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(final CreateIdentityPoolRequest createIdentityPoolRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateIdentityPoolResult>(){

            @Override
            public CreateIdentityPoolResult call() throws Exception {
                return AmazonCognitoIdentityAsyncClient.this.createIdentityPool(createIdentityPoolRequest);
            }
        });
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(final CreateIdentityPoolRequest createIdentityPoolRequest, final AsyncHandler<CreateIdentityPoolRequest, CreateIdentityPoolResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateIdentityPoolResult>(){

            @Override
            public CreateIdentityPoolResult call() throws Exception {
                CreateIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.createIdentityPool(createIdentityPoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createIdentityPoolRequest, result);
                return result;
            }
        });
    }
}

