/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.transform.Marshaller;

public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    @Override
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        if (listInvalidationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInvalidationsRequest> request = new DefaultRequest<ListInvalidationsRequest>(listInvalidationsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2014-05-31/distribution/{DistributionId}/invalidation?Marker={Marker}&MaxItems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(listInvalidationsRequest.getDistributionId()));
        uriResourcePath = uriResourcePath.replace("{Marker}", this.getString(listInvalidationsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listInvalidationsRequest.getMaxItems()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

