
/**
 * Synchronous and asynchronous client classes for accessing AmazonRDS.
 *
 * Amazon Relational Database Service <p>
 * Amazon Relational Database Service (Amazon RDS) is a web service that
 * makes it easier to set up, operate, and scale a relational database in
 * the cloud. It provides cost-efficient, resizable capacity for an
 * industry-standard relational database and manages common database
 * administration tasks, freeing up developers to focus on what makes
 * their applications and businesses unique.
 * </p>
 * <p>
 * Amazon RDS gives you access to the capabilities of a familiar MySQL
 * or Oracle database server. This means the code, applications, and
 * tools you already use today with your existing MySQL or Oracle
 * databases work with Amazon RDS without modification. Amazon RDS
 * automatically backs up your database and maintains the database
 * software that powers your DB instance. Amazon RDS is flexible: you can
 * scale your database instance's compute resources and storage capacity
 * to meet your application's demand. As with all Amazon Web Services,
 * there are no up-front investments, and you pay only for the resources
 * you use.
 * </p>
 * <p>
 * This is an interface reference for Amazon RDS. It contains
 * documentation for a programming or command line interface you can use
 * to manage Amazon RDS. Note that Amazon RDS is asynchronous, which
 * means that some interfaces may require techniques such as polling or
 * callback functions to determine when a command has been applied. In
 * this reference, the parameter descriptions indicate whether a command
 * is applied immediately, on the next instance reboot, or during the
 * maintenance window. For a summary of the Amazon RDS interfaces, go to
 * <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces"> Available RDS Interfaces </a>
 * .
 * </p>
 */
 package com.amazonaws.services.rds;
        