/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class S3Link {
    private final S3ClientCache s3cc;
    private final ID id;

    S3Link(S3ClientCache s3cc, String bucketName, String key) {
        this(s3cc, new ID(bucketName, key));
    }

    S3Link(S3ClientCache s3cc, Region region, String bucketName, String key) {
        this(s3cc, new ID(region, bucketName, key));
    }

    private S3Link(S3ClientCache s3cc, ID id) {
        this.s3cc = s3cc;
        this.id = id;
        if (s3cc == null) {
            throw new IllegalArgumentException("S3ClientCache must be configured for use with S3Link");
        }
        if (id == null || id.getBucket() == null || id.getKey() == null) {
            throw new IllegalArgumentException("Bucket and key must be specified for S3Link");
        }
    }

    public String getKey() {
        return this.id.getKey();
    }

    public String getBucketName() {
        return this.id.getBucket();
    }

    public Region getS3Region() {
        return Region.fromValue(this.id.getRegionId());
    }

    String toJson() {
        return this.id.toJson();
    }

    static S3Link fromJson(S3ClientCache s3cc, String json) {
        ID id = Jackson.fromJsonString(json, ID.class);
        return new S3Link(s3cc, id);
    }

    public AmazonS3Client getAmazonS3Client() {
        return this.s3cc.getClient(this.getS3Region());
    }

    public TransferManager getTransferManager() {
        return this.s3cc.getTransferManager(this.getS3Region());
    }

    public PutObjectResult uploadFrom(File source) {
        return this.uploadFrom0(source, null);
    }

    public PutObjectResult uploadFrom(File source, RequestMetricCollector requestMetricCollector) {
        return this.uploadFrom0(source, requestMetricCollector);
    }

    private PutObjectResult uploadFrom0(File source, RequestMetricCollector requestMetricCollector) {
        PutObjectRequest req = (PutObjectRequest)new PutObjectRequest(this.getBucketName(), this.getKey(), source).withRequestMetricCollector(requestMetricCollector);
        return this.getAmazonS3Client().putObject(req);
    }

    public PutObjectResult uploadFrom(byte[] buffer) {
        return this.uploadFrom0(buffer, null);
    }

    public PutObjectResult uploadFrom(byte[] buffer, RequestMetricCollector requestMetricCollector) {
        return this.uploadFrom0(buffer, requestMetricCollector);
    }

    private PutObjectResult uploadFrom0(byte[] buffer, RequestMetricCollector requestMetricCollector) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(buffer.length);
        PutObjectRequest req = (PutObjectRequest)new PutObjectRequest(this.getBucketName(), this.getKey(), new ByteArrayInputStream(buffer), objectMetadata).withRequestMetricCollector(requestMetricCollector);
        return this.getAmazonS3Client().putObject(req);
    }

    public void setAcl(CannedAccessControlList acl) {
        this.setAcl0(acl, null);
    }

    public void setAcl(CannedAccessControlList acl, RequestMetricCollector col) {
        this.setAcl0(acl, col);
    }

    private void setAcl0(CannedAccessControlList acl, RequestMetricCollector col) {
        this.getAmazonS3Client().setObjectAcl(this.getBucketName(), this.getKey(), null, acl, col);
    }

    public void setAcl(AccessControlList acl) {
        this.setAcl0(acl, null);
    }

    public void setAcl(AccessControlList acl, RequestMetricCollector requestMetricCollector) {
        this.setAcl0(acl, requestMetricCollector);
    }

    private void setAcl0(AccessControlList acl, RequestMetricCollector requestMetricCollector) {
        this.getAmazonS3Client().setObjectAcl(this.getBucketName(), this.getKey(), null, acl, requestMetricCollector);
    }

    public URL getUrl() {
        return this.getAmazonS3Client().getUrl(this.getBucketName(), this.getKey());
    }

    public ObjectMetadata downloadTo(File destination) {
        return this.downloadTo0(destination, null);
    }

    public ObjectMetadata downloadTo(File destination, RequestMetricCollector requestMetricCollector) {
        return this.downloadTo0(destination, requestMetricCollector);
    }

    private ObjectMetadata downloadTo0(File destination, RequestMetricCollector requestMetricCollector) {
        GetObjectRequest req = (GetObjectRequest)new GetObjectRequest(this.getBucketName(), this.getKey()).withRequestMetricCollector(requestMetricCollector);
        return this.getAmazonS3Client().getObject(req, destination);
    }

    public ObjectMetadata downloadTo(OutputStream output) {
        return this.downloadTo0(output, null);
    }

    public ObjectMetadata downloadTo(OutputStream output, RequestMetricCollector requestMetricCollector) {
        return this.downloadTo0(output, requestMetricCollector);
    }

    private ObjectMetadata downloadTo0(OutputStream output, RequestMetricCollector requestMetricCollector) {
        GetObjectRequest req = (GetObjectRequest)new GetObjectRequest(this.getBucketName(), this.getKey()).withRequestMetricCollector(requestMetricCollector);
        S3Object s3Object = this.getAmazonS3Client().getObject(req);
        S3ObjectInputStream objectContent = s3Object.getObjectContent();
        try {
            byte[] buffer = new byte[10240];
            int bytesRead = -1;
            while ((bytesRead = objectContent.read(buffer)) > -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            objectContent.abort();
            throw new AmazonClientException("Unable to transfer content from Amazon S3 to the output stream", ioe);
        }
        finally {
            try {
                objectContent.close();
            }
            catch (IOException ioe) {}
        }
        return s3Object.getObjectMetadata();
    }

    private static class S3 {
        @JsonProperty(value="region")
        private String regionId;
        @JsonProperty(value="bucket")
        private String bucket;
        @JsonProperty(value="key")
        private String key;

        S3() {
        }

        S3(String bucket, String key) {
            this(null, bucket, key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        S3(Region region, String bucket, String key) {
            if (region == null) {
                if (!BucketNameUtils.isDNSBucketName(bucket)) throw new IllegalArgumentException("Region must be specified for bucket that cannot be addressed using virtual host style");
                this.regionId = Region.US_Standard.getFirstRegionId();
            } else {
                this.regionId = region.getFirstRegionId();
            }
            this.bucket = bucket;
            this.key = key;
        }

        @JsonProperty(value="bucket")
        public String getBucket() {
            return this.bucket;
        }

        @JsonProperty(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="region")
        public String getRegionId() {
            return this.regionId;
        }
    }

    static class ID {
        @JsonProperty(value="s3")
        private S3 s3;

        ID() {
        }

        ID(String bucketName, String key) {
            this.s3 = new S3(bucketName, key);
        }

        ID(Region region, String bucketName, String key) {
            this.s3 = new S3(region, bucketName, key);
        }

        ID(S3 s3) {
            this.s3 = s3;
        }

        @JsonProperty(value="s3")
        public S3 getS3() {
            return this.s3;
        }

        @JsonIgnore
        public String getRegionId() {
            return this.s3.getRegionId();
        }

        @JsonIgnore
        public String getBucket() {
            return this.s3.getBucket();
        }

        @JsonIgnore
        public String getKey() {
            return this.s3.getKey();
        }

        String toJson() {
            return Jackson.toJsonString(this);
        }
    }
}

