/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.internal.crypto.EncryptionUtils;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadCryptoContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleBase;
import com.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazonaws.services.s3.model.EncryptedGetObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

class S3CryptoModuleAE
extends S3CryptoModuleBase<MultipartUploadCryptoContext> {
    private static final boolean IS_MULTI_PART = true;

    S3CryptoModuleAE(S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        CryptoMode mode = cryptoConfig.getCryptoMode();
        if (mode != CryptoMode.StrictAuthenticatedEncryption && mode != CryptoMode.AuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    S3CryptoModuleAE(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(s3, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfig);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        this.appendUserAgent(putObjectRequest, AmazonS3EncryptionClient.USER_AGENT);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest req) {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        PutObjectRequest wrappedReq = this.wrapWithCipher(req, cekMaterial);
        req.setMetadata(this.updateMetadataWithContentCryptoMaterial(req.getMetadata(), req.getFile(), cekMaterial));
        return this.s3.putObject(wrappedReq);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest req) {
        S3Object retrieved;
        this.appendUserAgent(req, AmazonS3EncryptionClient.USER_AGENT);
        long[] desiredRange = req.getRange();
        if (this.isStrict() && desiredRange != null) {
            throw new SecurityException("Range get is not allowed in strict crypto mode");
        }
        long[] adjustedCryptoRange = EncryptionUtils.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        if ((retrieved = this.s3.getObject(req)) == null) {
            return null;
        }
        String suffix = null;
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            suffix = ereq.getInstructionFileSuffix();
        }
        try {
            return suffix == null || suffix.trim().isEmpty() ? this.decipher(req, desiredRange, adjustedCryptoRange, retrieved) : this.decipherWithInstFileSuffix(req, desiredRange, adjustedCryptoRange, retrieved, suffix);
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipher(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3Object retrieved) {
        S3ObjectWrapper wrapped = new S3ObjectWrapper(retrieved, req.getS3ObjectId());
        if (wrapped.hasEncryptionInfo()) {
            return this.decipherWithMetadata(req, desiredRange, cryptoRange, wrapped);
        }
        S3ObjectWrapper ifile = this.fetchInstructionFile(req.getS3ObjectId(), null);
        if (ifile != null) {
            try {
                if (ifile.isInstructionFile()) {
                    S3Object s3Object = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, wrapped, ifile);
                    return s3Object;
                }
            }
            finally {
                IOUtils.closeQuietly(ifile, this.log);
            }
        }
        if (this.isStrict()) {
            IOUtils.closeQuietly(wrapped, this.log);
            throw new SecurityException("S3 object with bucket name: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + " is not encrypted");
        }
        this.log.warn((Object)String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrieved.getKey(), retrieved.getBucketName()));
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(wrapped, desiredRange, null);
        return adjusted.getS3Object();
    }

    private S3Object decipherWithInstFileSuffix(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3Object retrieved, String instFileSuffix) {
        S3ObjectId id = req.getS3ObjectId();
        S3ObjectWrapper ifile = this.fetchInstructionFile(id, instFileSuffix);
        if (ifile == null) {
            throw new AmazonClientException("Instruction file with suffix " + instFileSuffix + " is not found for " + retrieved);
        }
        try {
            if (ifile.isInstructionFile()) {
                S3Object s3Object = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, new S3ObjectWrapper(retrieved, id), ifile);
                return s3Object;
            }
            throw new AmazonClientException("Invalid Instruction file with suffix " + instFileSuffix + " detected for " + retrieved);
        }
        finally {
            IOUtils.closeQuietly(ifile, this.log);
        }
    }

    private S3Object decipherWithInstructionFile(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved, S3ObjectWrapper instructionFile) {
        ExtraMaterialsDescription extraMatDesc = ExtraMaterialsDescription.NONE;
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            extraMatDesc = ereq.getExtraMaterialDescription();
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        String json = instructionFile.toJsonString();
        Map<String, String> matdesc = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromInstructionFile(matdesc, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, extraMatDesc, keyWrapExpected);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, matdesc);
        return adjusted.getS3Object();
    }

    private S3Object decipherWithMetadata(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved) {
        ExtraMaterialsDescription extraMatDesc = ExtraMaterialsDescription.NONE;
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            extraMatDesc = ereq.getExtraMaterialDescription();
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(retrieved.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, extraMatDesc, keyWrapExpected);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, null);
        return adjusted.getS3Object();
    }

    protected final S3ObjectWrapper adjustToDesiredRange(S3ObjectWrapper s3object, long[] range, Map<String, String> instruction) {
        if (range == null) {
            return s3object;
        }
        ContentCryptoScheme encryptionScheme = s3object.encryptionSchemeOf(instruction);
        long instanceLen = s3object.getObjectMetadata().getInstanceLength();
        long maxOffset = instanceLen - (long)(encryptionScheme.getTagLengthInBits() / 8) - 1L;
        if (range[1] > maxOffset) {
            range[1] = maxOffset;
            if (range[0] > range[1]) {
                IOUtils.closeQuietly(s3object.getObjectContent(), this.log);
                s3object.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return s3object;
            }
        }
        if (range[0] > range[1]) {
            return s3object;
        }
        try {
            S3ObjectInputStream objectContent = s3object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            s3object.setObjectContent(new S3ObjectInputStream(adjustedRangeContents, objectContent.getHttpRequest()));
            return s3object;
        }
        catch (IOException e) {
            throw new AmazonClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObjectSecurely(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream, this.log);
                IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(outputStream, this.log);
        IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
        return s3Object.getObjectMetadata();
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) {
        this.appendUserAgent(req, AmazonS3EncryptionClient.USER_AGENT);
        String uploadId = req.getUploadId();
        MultipartUploadCryptoContext uploadContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(uploadId);
        if (!uploadContext.hasFinalPartBeenSeen()) {
            throw new AmazonClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = this.s3.completeMultipartUpload(req);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.s3.putObject(this.createInstructionPutRequest(uploadContext.getBucketName(), uploadContext.getKey(), uploadContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) {
        this.appendUserAgent(req, AmazonS3EncryptionClient.USER_AGENT);
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            ObjectMetadata metadata = req.getObjectMetadata();
            if (metadata == null) {
                metadata = new ObjectMetadata();
            }
            req.setObjectMetadata(this.updateMetadataWithContentCryptoMaterial(metadata, null, cekMaterial));
        }
        InitiateMultipartUploadResult result = this.s3.initiateMultipartUpload(req);
        MultipartUploadCryptoContext uploadContext = new MultipartUploadCryptoContext(req.getBucketName(), req.getKey(), cekMaterial);
        this.multipartUploadContexts.put(result.getUploadId(), uploadContext);
        return result;
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) {
        boolean partSizeMultipleOfCipherBlockSize;
        this.appendUserAgent(req, AmazonS3EncryptionClient.USER_AGENT);
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean isLastPart = req.isLastPart();
        String uploadId = req.getUploadId();
        long partSize = req.getPartSize();
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new AmazonClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext uploadContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(uploadId);
        if (uploadContext == null) {
            throw new AmazonClientException("No client-side information available on upload ID " + uploadId);
        }
        CipherLite cipherLite = uploadContext.getCipherLite();
        req.setInputStream(this.newMultipartS3CipherInputStream(req, cipherLite));
        req.setFile(null);
        req.setFileOffset(0L);
        if (isLastPart) {
            req.setPartSize(partSize + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8));
            if (uploadContext.hasFinalPartBeenSeen()) {
                throw new AmazonClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
            }
        }
        UploadPartResult result = this.s3.uploadPart(req);
        if (isLastPart) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    protected final CipherLiteInputStream newMultipartS3CipherInputStream(UploadPartRequest req, CipherLite cipherLite) {
        try {
            InputStream is = req.getInputStream();
            if (req.getFile() != null) {
                is = new InputSubstream(new RepeatableFileInputStream(req.getFile()), req.getFileOffset(), req.getPartSize(), req.isLastPart());
            }
            return new CipherLiteInputStream(is, cipherLite, 2048, true);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) {
        PutObjectRequest putInstFileRequest = putObjectRequest.clone();
        putInstFileRequest.setKey(putInstFileRequest.getKey() + "." + "instruction");
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest req = this.wrapWithCipher(putObjectRequest, cekMaterial);
        PutObjectResult result = this.s3.putObject(req);
        this.s3.putObject(this.updateInstructionPutRequest(putInstFileRequest, cekMaterial));
        return result;
    }

    private S3ObjectWrapper decrypt(S3ObjectWrapper wrapper, ContentCryptoMaterial cekMaterial, long[] range) {
        S3ObjectInputStream objectContent = wrapper.getObjectContent();
        wrapper.setObjectContent(new S3ObjectInputStream(new CipherLiteInputStream(objectContent, cekMaterial.getCipherLite(), 2048), objectContent.getHttpRequest()));
        return wrapper;
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected final long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

