/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public enum IOUtils {

    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            output.close();
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(IOUtils.toByteArray(is), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable is, Log log) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    if (log == null) break block3;
                    log.debug((Object)"Ignore failure in closing the Closeable", (Throwable)ex);
                }
            }
        }
    }
}

