/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.DescribeTapesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeTapesRequestMarshaller
implements Marshaller<Request<DescribeTapesRequest>, DescribeTapesRequest> {
    @Override
    public Request<DescribeTapesRequest> marshall(DescribeTapesRequest describeTapesRequest) {
        if (describeTapesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTapesRequest> request = new DefaultRequest<DescribeTapesRequest>(describeTapesRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.DescribeTapes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tapeARNsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeTapesRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(describeTapesRequest.getGatewayARN());
            }
            if (!((tapeARNsList = (ListWithAutoConstructFlag)describeTapesRequest.getTapeARNs()) == null || tapeARNsList.isAutoConstruct() && tapeARNsList.isEmpty())) {
                jsonWriter.key("TapeARNs");
                jsonWriter.array();
                for (String tapeARNsListValue : tapeARNsList) {
                    if (tapeARNsListValue == null) continue;
                    jsonWriter.value(tapeARNsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeTapesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(describeTapesRequest.getMarker());
            }
            if (describeTapesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeTapesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

