/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListIdentityPoolUsageRequestMarshaller
implements Marshaller<Request<ListIdentityPoolUsageRequest>, ListIdentityPoolUsageRequest> {
    @Override
    public Request<ListIdentityPoolUsageRequest> marshall(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        if (listIdentityPoolUsageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListIdentityPoolUsageRequest> request = new DefaultRequest<ListIdentityPoolUsageRequest>(listIdentityPoolUsageRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.ListIdentityPoolUsage";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools?maxResults={MaxResults};nextToken={NextToken}";
        uriResourcePath = uriResourcePath.replace("{NextToken}", listIdentityPoolUsageRequest.getNextToken() == null ? "" : StringUtils.fromString(listIdentityPoolUsageRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{MaxResults}", listIdentityPoolUsageRequest.getMaxResults() == null ? "" : StringUtils.fromInteger(listIdentityPoolUsageRequest.getMaxResults()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

