/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.Expression;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DefineExpressionRequestMarshaller
implements Marshaller<Request<DefineExpressionRequest>, DefineExpressionRequest> {
    public Request<DefineExpressionRequest> marshall(DefineExpressionRequest defineExpressionRequest) {
        Expression expressionExpression;
        if (defineExpressionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineExpressionRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineExpression");
        request.addParameter("Version", "2013-01-01");
        if (defineExpressionRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineExpressionRequest.getDomainName()));
        }
        if ((expressionExpression = defineExpressionRequest.getExpression()) != null) {
            if (expressionExpression.getExpressionName() != null) {
                request.addParameter("Expression.ExpressionName", StringUtils.fromString((String)expressionExpression.getExpressionName()));
            }
            if (expressionExpression.getExpressionValue() != null) {
                request.addParameter("Expression.ExpressionValue", StringUtils.fromString((String)expressionExpression.getExpressionValue()));
            }
        }
        return request;
    }
}

