/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.DBInstanceStatusInfo;
import com.amazonaws.services.rds.model.DBParameterGroupStatus;
import com.amazonaws.services.rds.model.DBSecurityGroupMembership;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.Endpoint;
import com.amazonaws.services.rds.model.OptionGroupMembership;
import com.amazonaws.services.rds.model.PendingModifiedValues;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBInstance
implements Serializable {
    private String dBInstanceIdentifier;
    private String dBInstanceClass;
    private String engine;
    private String dBInstanceStatus;
    private String masterUsername;
    private String dBName;
    private Endpoint endpoint;
    private Integer allocatedStorage;
    private Date instanceCreateTime;
    private String preferredBackupWindow;
    private Integer backupRetentionPeriod;
    private ListWithAutoConstructFlag<DBSecurityGroupMembership> dBSecurityGroups;
    private ListWithAutoConstructFlag<VpcSecurityGroupMembership> vpcSecurityGroups;
    private ListWithAutoConstructFlag<DBParameterGroupStatus> dBParameterGroups;
    private String availabilityZone;
    private DBSubnetGroup dBSubnetGroup;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private Date latestRestorableTime;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String readReplicaSourceDBInstanceIdentifier;
    private ListWithAutoConstructFlag<String> readReplicaDBInstanceIdentifiers;
    private String licenseModel;
    private Integer iops;
    private ListWithAutoConstructFlag<OptionGroupMembership> optionGroupMemberships;
    private String characterSetName;
    private String secondaryAvailabilityZone;
    private Boolean publiclyAccessible;
    private ListWithAutoConstructFlag<DBInstanceStatusInfo> statusInfos;

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public DBInstance withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public DBInstance withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public DBInstance withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getDBInstanceStatus() {
        return this.dBInstanceStatus;
    }

    public void setDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
    }

    public DBInstance withDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public DBInstance withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public DBInstance withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public DBInstance withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public DBInstance withAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
        return this;
    }

    public Date getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public void setInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public DBInstance withInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
        return this;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public DBInstance withPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public DBInstance withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
        return this;
    }

    public List<DBSecurityGroupMembership> getDBSecurityGroups() {
        if (this.dBSecurityGroups == null) {
            this.dBSecurityGroups = new ListWithAutoConstructFlag();
            this.dBSecurityGroups.setAutoConstruct(true);
        }
        return this.dBSecurityGroups;
    }

    public void setDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag dBSecurityGroupsCopy = new ListWithAutoConstructFlag(dBSecurityGroups.size());
        dBSecurityGroupsCopy.addAll(dBSecurityGroups);
        this.dBSecurityGroups = dBSecurityGroupsCopy;
    }

    public DBInstance withDBSecurityGroups(DBSecurityGroupMembership ... dBSecurityGroups) {
        if (this.getDBSecurityGroups() == null) {
            this.setDBSecurityGroups(new ArrayList<DBSecurityGroupMembership>(dBSecurityGroups.length));
        }
        for (DBSecurityGroupMembership value : dBSecurityGroups) {
            this.getDBSecurityGroups().add(value);
        }
        return this;
    }

    public DBInstance withDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag dBSecurityGroupsCopy = new ListWithAutoConstructFlag(dBSecurityGroups.size());
            dBSecurityGroupsCopy.addAll(dBSecurityGroups);
            this.dBSecurityGroups = dBSecurityGroupsCopy;
        }
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new ListWithAutoConstructFlag();
            this.vpcSecurityGroups.setAutoConstruct(true);
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
        vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
        this.vpcSecurityGroups = vpcSecurityGroupsCopy;
    }

    public DBInstance withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.getVpcSecurityGroups() == null) {
            this.setVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership value : vpcSecurityGroups) {
            this.getVpcSecurityGroups().add(value);
        }
        return this;
    }

    public DBInstance withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
            vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
            this.vpcSecurityGroups = vpcSecurityGroupsCopy;
        }
        return this;
    }

    public List<DBParameterGroupStatus> getDBParameterGroups() {
        if (this.dBParameterGroups == null) {
            this.dBParameterGroups = new ListWithAutoConstructFlag();
            this.dBParameterGroups.setAutoConstruct(true);
        }
        return this.dBParameterGroups;
    }

    public void setDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        if (dBParameterGroups == null) {
            this.dBParameterGroups = null;
            return;
        }
        ListWithAutoConstructFlag dBParameterGroupsCopy = new ListWithAutoConstructFlag(dBParameterGroups.size());
        dBParameterGroupsCopy.addAll(dBParameterGroups);
        this.dBParameterGroups = dBParameterGroupsCopy;
    }

    public DBInstance withDBParameterGroups(DBParameterGroupStatus ... dBParameterGroups) {
        if (this.getDBParameterGroups() == null) {
            this.setDBParameterGroups(new ArrayList<DBParameterGroupStatus>(dBParameterGroups.length));
        }
        for (DBParameterGroupStatus value : dBParameterGroups) {
            this.getDBParameterGroups().add(value);
        }
        return this;
    }

    public DBInstance withDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        if (dBParameterGroups == null) {
            this.dBParameterGroups = null;
        } else {
            ListWithAutoConstructFlag dBParameterGroupsCopy = new ListWithAutoConstructFlag(dBParameterGroups.size());
            dBParameterGroupsCopy.addAll(dBParameterGroups);
            this.dBParameterGroups = dBParameterGroupsCopy;
        }
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public DBInstance withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public DBSubnetGroup getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public void setDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public DBInstance withDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public DBInstance withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public DBInstance withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public DBInstance withLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public DBInstance withMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
        return this;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public DBInstance withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public DBInstance withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String getReadReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
    }

    public DBInstance withReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        return this;
    }

    public List<String> getReadReplicaDBInstanceIdentifiers() {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = new ListWithAutoConstructFlag();
            this.readReplicaDBInstanceIdentifiers.setAutoConstruct(true);
        }
        return this.readReplicaDBInstanceIdentifiers;
    }

    public void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
            return;
        }
        ListWithAutoConstructFlag readReplicaDBInstanceIdentifiersCopy = new ListWithAutoConstructFlag(readReplicaDBInstanceIdentifiers.size());
        readReplicaDBInstanceIdentifiersCopy.addAll(readReplicaDBInstanceIdentifiers);
        this.readReplicaDBInstanceIdentifiers = readReplicaDBInstanceIdentifiersCopy;
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
        if (this.getReadReplicaDBInstanceIdentifiers() == null) {
            this.setReadReplicaDBInstanceIdentifiers(new ArrayList<String>(readReplicaDBInstanceIdentifiers.length));
        }
        for (String value : readReplicaDBInstanceIdentifiers) {
            this.getReadReplicaDBInstanceIdentifiers().add(value);
        }
        return this;
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
        } else {
            ListWithAutoConstructFlag readReplicaDBInstanceIdentifiersCopy = new ListWithAutoConstructFlag(readReplicaDBInstanceIdentifiers.size());
            readReplicaDBInstanceIdentifiersCopy.addAll(readReplicaDBInstanceIdentifiers);
            this.readReplicaDBInstanceIdentifiers = readReplicaDBInstanceIdentifiersCopy;
        }
        return this;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public DBInstance withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public DBInstance withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public List<OptionGroupMembership> getOptionGroupMemberships() {
        if (this.optionGroupMemberships == null) {
            this.optionGroupMemberships = new ListWithAutoConstructFlag();
            this.optionGroupMemberships.setAutoConstruct(true);
        }
        return this.optionGroupMemberships;
    }

    public void setOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
        if (optionGroupMemberships == null) {
            this.optionGroupMemberships = null;
            return;
        }
        ListWithAutoConstructFlag optionGroupMembershipsCopy = new ListWithAutoConstructFlag(optionGroupMemberships.size());
        optionGroupMembershipsCopy.addAll(optionGroupMemberships);
        this.optionGroupMemberships = optionGroupMembershipsCopy;
    }

    public DBInstance withOptionGroupMemberships(OptionGroupMembership ... optionGroupMemberships) {
        if (this.getOptionGroupMemberships() == null) {
            this.setOptionGroupMemberships(new ArrayList<OptionGroupMembership>(optionGroupMemberships.length));
        }
        for (OptionGroupMembership value : optionGroupMemberships) {
            this.getOptionGroupMemberships().add(value);
        }
        return this;
    }

    public DBInstance withOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
        if (optionGroupMemberships == null) {
            this.optionGroupMemberships = null;
        } else {
            ListWithAutoConstructFlag optionGroupMembershipsCopy = new ListWithAutoConstructFlag(optionGroupMemberships.size());
            optionGroupMembershipsCopy.addAll(optionGroupMemberships);
            this.optionGroupMemberships = optionGroupMembershipsCopy;
        }
        return this;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public DBInstance withCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
        return this;
    }

    public String getSecondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
    }

    public DBInstance withSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public DBInstance withPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
        return this;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> getStatusInfos() {
        if (this.statusInfos == null) {
            this.statusInfos = new ListWithAutoConstructFlag();
            this.statusInfos.setAutoConstruct(true);
        }
        return this.statusInfos;
    }

    public void setStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
            return;
        }
        ListWithAutoConstructFlag statusInfosCopy = new ListWithAutoConstructFlag(statusInfos.size());
        statusInfosCopy.addAll(statusInfos);
        this.statusInfos = statusInfosCopy;
    }

    public DBInstance withStatusInfos(DBInstanceStatusInfo ... statusInfos) {
        if (this.getStatusInfos() == null) {
            this.setStatusInfos(new ArrayList<DBInstanceStatusInfo>(statusInfos.length));
        }
        for (DBInstanceStatusInfo value : statusInfos) {
            this.getStatusInfos().add(value);
        }
        return this;
    }

    public DBInstance withStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
        } else {
            ListWithAutoConstructFlag statusInfosCopy = new ListWithAutoConstructFlag(statusInfos.size());
            statusInfosCopy.addAll(statusInfos);
            this.statusInfos = statusInfosCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: " + this.getDBInstanceIdentifier() + ",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: " + this.getDBInstanceClass() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getDBInstanceStatus() != null) {
            sb.append("DBInstanceStatus: " + this.getDBInstanceStatus() + ",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: " + this.getMasterUsername() + ",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: " + this.getDBName() + ",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: " + this.getEndpoint() + ",");
        }
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: " + this.getAllocatedStorage() + ",");
        }
        if (this.getInstanceCreateTime() != null) {
            sb.append("InstanceCreateTime: " + this.getInstanceCreateTime() + ",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: " + this.getPreferredBackupWindow() + ",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: " + this.getBackupRetentionPeriod() + ",");
        }
        if (this.getDBSecurityGroups() != null) {
            sb.append("DBSecurityGroups: " + this.getDBSecurityGroups() + ",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: " + this.getVpcSecurityGroups() + ",");
        }
        if (this.getDBParameterGroups() != null) {
            sb.append("DBParameterGroups: " + this.getDBParameterGroups() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: " + this.getDBSubnetGroup() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: " + this.getPendingModifiedValues() + ",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: " + this.getLatestRestorableTime() + ",");
        }
        if (this.isMultiAZ() != null) {
            sb.append("MultiAZ: " + this.isMultiAZ() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getReadReplicaSourceDBInstanceIdentifier() != null) {
            sb.append("ReadReplicaSourceDBInstanceIdentifier: " + this.getReadReplicaSourceDBInstanceIdentifier() + ",");
        }
        if (this.getReadReplicaDBInstanceIdentifiers() != null) {
            sb.append("ReadReplicaDBInstanceIdentifiers: " + this.getReadReplicaDBInstanceIdentifiers() + ",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: " + this.getLicenseModel() + ",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: " + this.getIops() + ",");
        }
        if (this.getOptionGroupMemberships() != null) {
            sb.append("OptionGroupMemberships: " + this.getOptionGroupMemberships() + ",");
        }
        if (this.getCharacterSetName() != null) {
            sb.append("CharacterSetName: " + this.getCharacterSetName() + ",");
        }
        if (this.getSecondaryAvailabilityZone() != null) {
            sb.append("SecondaryAvailabilityZone: " + this.getSecondaryAvailabilityZone() + ",");
        }
        if (this.isPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.isPubliclyAccessible() + ",");
        }
        if (this.getStatusInfos() != null) {
            sb.append("StatusInfos: " + this.getStatusInfos());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceStatus() == null ? 0 : this.getDBInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreateTime() == null ? 0 : this.getInstanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroups() == null ? 0 : this.getDBSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroups() == null ? 0 : this.getDBParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZ() == null ? 0 : this.isMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaSourceDBInstanceIdentifier() == null ? 0 : this.getReadReplicaSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaDBInstanceIdentifiers() == null ? 0 : this.getReadReplicaDBInstanceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupMemberships() == null ? 0 : this.getOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryAvailabilityZone() == null ? 0 : this.getSecondaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.isPubliclyAccessible() == null ? 0 : this.isPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getStatusInfos() == null ? 0 : this.getStatusInfos().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getDBInstanceStatus() == null ^ this.getDBInstanceStatus() == null) {
            return false;
        }
        if (other.getDBInstanceStatus() != null && !other.getDBInstanceStatus().equals(this.getDBInstanceStatus())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getInstanceCreateTime() == null ^ this.getInstanceCreateTime() == null) {
            return false;
        }
        if (other.getInstanceCreateTime() != null && !other.getInstanceCreateTime().equals(this.getInstanceCreateTime())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getDBSecurityGroups() == null ^ this.getDBSecurityGroups() == null) {
            return false;
        }
        if (other.getDBSecurityGroups() != null && !other.getDBSecurityGroups().equals(this.getDBSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getDBParameterGroups() == null ^ this.getDBParameterGroups() == null) {
            return false;
        }
        if (other.getDBParameterGroups() != null && !other.getDBParameterGroups().equals(this.getDBParameterGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.isMultiAZ() == null ^ this.isMultiAZ() == null) {
            return false;
        }
        if (other.isMultiAZ() != null && !other.isMultiAZ().equals(this.isMultiAZ())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() == null ^ this.getReadReplicaSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() != null && !other.getReadReplicaSourceDBInstanceIdentifier().equals(this.getReadReplicaSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() == null ^ this.getReadReplicaDBInstanceIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() != null && !other.getReadReplicaDBInstanceIdentifiers().equals(this.getReadReplicaDBInstanceIdentifiers())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getOptionGroupMemberships() == null ^ this.getOptionGroupMemberships() == null) {
            return false;
        }
        if (other.getOptionGroupMemberships() != null && !other.getOptionGroupMemberships().equals(this.getOptionGroupMemberships())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        if (other.getCharacterSetName() != null && !other.getCharacterSetName().equals(this.getCharacterSetName())) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() == null ^ this.getSecondaryAvailabilityZone() == null) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() != null && !other.getSecondaryAvailabilityZone().equals(this.getSecondaryAvailabilityZone())) {
            return false;
        }
        if (other.isPubliclyAccessible() == null ^ this.isPubliclyAccessible() == null) {
            return false;
        }
        if (other.isPubliclyAccessible() != null && !other.isPubliclyAccessible().equals(this.isPubliclyAccessible())) {
            return false;
        }
        if (other.getStatusInfos() == null ^ this.getStatusInfos() == null) {
            return false;
        }
        return other.getStatusInfos() == null || other.getStatusInfos().equals(this.getStatusInfos());
    }
}

