/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;

public class DynamoDBMapperConfig {
    private final SaveBehavior saveBehavior;
    private final ConsistentReads consistentReads;
    private final TableNameOverride tableNameOverride;
    private final TableNameResolver tableNameResolver;
    private final ObjectTableNameResolver objectTableNameResolver;
    private final PaginationLoadingStrategy paginationLoadingStrategy;
    private final RequestMetricCollector requestMetricCollector;
    public static final DynamoDBMapperConfig DEFAULT = new DynamoDBMapperConfig(SaveBehavior.UPDATE, ConsistentReads.EVENTUAL, null, PaginationLoadingStrategy.LAZY_LOADING);

    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null, null, null);
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null, paginationLoadingStrategy, null);
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null, paginationLoadingStrategy, requestMetricCollector);
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector) {
        this.saveBehavior = saveBehavior;
        this.consistentReads = consistentReads;
        this.tableNameOverride = tableNameOverride;
        this.tableNameResolver = tableNameResolver;
        this.objectTableNameResolver = objectTableNameResolver;
        this.paginationLoadingStrategy = paginationLoadingStrategy;
        this.requestMetricCollector = requestMetricCollector;
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior) {
        this(saveBehavior, null, null, null);
    }

    public DynamoDBMapperConfig(ConsistentReads consistentReads) {
        this(null, consistentReads, null, null);
    }

    public DynamoDBMapperConfig(TableNameOverride tableNameOverride) {
        this(null, null, tableNameOverride, null);
    }

    public DynamoDBMapperConfig(PaginationLoadingStrategy paginationLoadingStrategy) {
        this(null, null, null, paginationLoadingStrategy);
    }

    public DynamoDBMapperConfig(TableNameResolver tableNameResolver) {
        this(null, null, null, tableNameResolver, null, null, null);
    }

    public DynamoDBMapperConfig(ObjectTableNameResolver tableNameResolver) {
        this(null, null, null, null, tableNameResolver, null, null);
    }

    public DynamoDBMapperConfig(TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver) {
        this(null, null, null, tableNameResolver, objectTableNameResolver, null, null);
    }

    public DynamoDBMapperConfig(DynamoDBMapperConfig defaults, DynamoDBMapperConfig overrides) {
        if (overrides == null) {
            this.saveBehavior = defaults.getSaveBehavior();
            this.consistentReads = defaults.getConsistentReads();
            this.tableNameOverride = defaults.getTableNameOverride();
            this.tableNameResolver = defaults.getTableNameResolver();
            this.objectTableNameResolver = defaults.getObjectTableNameResolver();
            this.paginationLoadingStrategy = defaults.getPaginationLoadingStrategy();
            this.requestMetricCollector = defaults.getRequestMetricCollector();
        } else {
            this.saveBehavior = overrides.getSaveBehavior() == null ? defaults.getSaveBehavior() : overrides.getSaveBehavior();
            this.consistentReads = overrides.getConsistentReads() == null ? defaults.getConsistentReads() : overrides.getConsistentReads();
            this.tableNameOverride = overrides.getTableNameOverride() == null ? defaults.getTableNameOverride() : overrides.getTableNameOverride();
            this.tableNameResolver = overrides.getTableNameResolver() == null ? defaults.getTableNameResolver() : overrides.getTableNameResolver();
            this.objectTableNameResolver = overrides.getObjectTableNameResolver() == null ? defaults.getObjectTableNameResolver() : overrides.getObjectTableNameResolver();
            this.paginationLoadingStrategy = overrides.getPaginationLoadingStrategy() == null ? defaults.getPaginationLoadingStrategy() : overrides.getPaginationLoadingStrategy();
            this.requestMetricCollector = overrides.getRequestMetricCollector() == null ? defaults.getRequestMetricCollector() : overrides.getRequestMetricCollector();
        }
    }

    public SaveBehavior getSaveBehavior() {
        return this.saveBehavior;
    }

    public ConsistentReads getConsistentReads() {
        return this.consistentReads;
    }

    public TableNameOverride getTableNameOverride() {
        return this.tableNameOverride;
    }

    public TableNameResolver getTableNameResolver() {
        return this.tableNameResolver;
    }

    public ObjectTableNameResolver getObjectTableNameResolver() {
        return this.objectTableNameResolver;
    }

    public PaginationLoadingStrategy getPaginationLoadingStrategy() {
        return this.paginationLoadingStrategy;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public static class DefaultTableNameResolver
    implements TableNameResolver {
        public static final DefaultTableNameResolver INSTANCE = new DefaultTableNameResolver();
        private final DynamoDBReflector reflector = new DynamoDBReflector();

        @Override
        public String getTableName(Class<?> clazz, DynamoDBMapperConfig config) {
            DynamoDBTable table = this.reflector.getTable(clazz);
            String tableName = table.tableName();
            if (config.getTableNameOverride() != null) {
                tableName = config.getTableNameOverride().getTableName() != null ? config.getTableNameOverride().getTableName() : config.getTableNameOverride().getTableNamePrefix() + tableName;
            }
            return tableName;
        }
    }

    public static interface ObjectTableNameResolver {
        public String getTableName(Object var1, DynamoDBMapperConfig var2);
    }

    public static interface TableNameResolver {
        public String getTableName(Class<?> var1, DynamoDBMapperConfig var2);
    }

    public static final class TableNameOverride {
        private final String tableNameOverride;
        private final String tableNamePrefix;

        public static TableNameOverride withTableNamePrefix(String tableNamePrefix) {
            return new TableNameOverride(null, tableNamePrefix);
        }

        public static TableNameOverride withTableNameReplacement(String tableNameReplacement) {
            return new TableNameOverride(tableNameReplacement, null);
        }

        private TableNameOverride(String tableNameOverride, String tableNamePrefix) {
            this.tableNameOverride = tableNameOverride;
            this.tableNamePrefix = tableNamePrefix;
        }

        public TableNameOverride(String tableNameOverride) {
            this(tableNameOverride, null);
        }

        public String getTableName() {
            return this.tableNameOverride;
        }

        public String getTableNamePrefix() {
            return this.tableNamePrefix;
        }
    }

    public static enum PaginationLoadingStrategy {
        LAZY_LOADING,
        ITERATION_ONLY,
        EAGER_LOADING;

    }

    public static enum ConsistentReads {
        CONSISTENT,
        EVENTUAL;

    }

    public static enum SaveBehavior {
        UPDATE,
        UPDATE_SKIP_NULL_ATTRIBUTES,
        CLOBBER,
        APPEND_SET;

    }
}

