/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.PauseResult;
import com.amazonaws.services.s3.transfer.PauseStatus;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private final ProgressListenerChain listener;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isUploadDone = false;
    private Future<UploadResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<UploadResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<UploadResult> nextFuture) {
        this.nextFuture = nextFuture;
    }

    private synchronized void cancelNextFuture() {
        this.nextFuture.cancel(true);
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartUploadCallable = multipartUploadCallable;
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.setNextFuture(threadPool.submit(this));
    }

    public void setTimedThreadPool(ScheduledExecutorService timedThreadPool) {
        this.timedThreadPool = timedThreadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.upload();
            }
            return this.poll();
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress((ProgressListener)this.listener, (ProgressEventType)ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            SDKProgressPublisher.publishProgress((ProgressListener)this.listener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
    }

    private UploadResult poll() throws InterruptedException {
        for (Future<PartETag> f : this.futures) {
            if (f.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> f : this.futures) {
            if (!f.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private UploadResult upload() throws Exception, InterruptedException {
        UploadResult result = this.multipartUploadCallable.call();
        if (result != null) {
            this.uploadComplete();
        } else {
            this.uploadId = this.multipartUploadCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartUploadCallable.getFutures());
            this.reschedule();
        }
        return result;
    }

    private void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress((ProgressListener)this.listener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<UploadResult>(){

            @Override
            public UploadResult call() throws Exception {
                UploadMonitor.this.setNextFuture(UploadMonitor.this.threadPool.submit(UploadMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private UploadResult completeMultipartUpload() {
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.uploadId, this.collectPartETags()));
        this.uploadComplete();
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
        uploadResult.setKey(completeMultipartUploadResult.getKey());
        uploadResult.setETag(completeMultipartUploadResult.getETag());
        uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return uploadResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        partETags.addAll(this.multipartUploadCallable.getETags());
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to upload part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }

    PauseResult<PersistableUpload> pause(boolean forceCancel) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), forceCancel);
            if (forceCancel) {
                this.cancelFutures();
                this.multipartUploadCallable.performAbortMultipartUpload();
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.cancelFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelFutures() {
        this.cancelNextFuture();
        for (Future<PartETag> f : this.futures) {
            f.cancel(true);
        }
        this.multipartUploadCallable.getFutures().clear();
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        this.multipartUploadCallable.performAbortMultipartUpload();
    }
}

