/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import java.net.URI;
import java.net.URISyntaxException;

public class QueueUrlHandler
extends AbstractRequestHandler {
    private static final String QUEUE_URL_PARAMETER = "QueueUrl";

    @Override
    public void beforeRequest(Request<?> request) {
        if (request.getParameters().get(QUEUE_URL_PARAMETER) != null) {
            String queueUrl = request.getParameters().remove(QUEUE_URL_PARAMETER);
            try {
                URI uri = new URI(queueUrl);
                request.setResourcePath(uri.getPath());
                if (uri.getHost() != null) {
                    URI uriWithoutPath = new URI(uri.toString().replace(uri.getPath(), ""));
                    request.setEndpoint(uriWithoutPath);
                }
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse SQS queue URL '" + queueUrl + "'", e);
            }
        }
    }
}

